/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PipelinedOutputBuffers
extends OutputBuffers {
    public static final int BROADCAST_PARTITION_ID = 0;
    private final BufferType type;
    private final Map<OutputBufferId, Integer> buffers;
    private final boolean noMoreBufferIds;

    public static PipelinedOutputBuffers createInitial(BufferType type) {
        return new PipelinedOutputBuffers(0L, type, (Map<OutputBufferId, Integer>)ImmutableMap.of(), false);
    }

    public static PipelinedOutputBuffers createInitial(PartitioningHandle partitioningHandle) {
        BufferType type = partitioningHandle.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) ? BufferType.BROADCAST : (partitioningHandle.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) ? BufferType.ARBITRARY : BufferType.PARTITIONED);
        return new PipelinedOutputBuffers(0L, type, (Map<OutputBufferId, Integer>)ImmutableMap.of(), false);
    }

    @JsonCreator
    public PipelinedOutputBuffers(@JsonProperty(value="version") long version, @JsonProperty(value="type") BufferType type, @JsonProperty(value="buffers") Map<OutputBufferId, Integer> buffers, @JsonProperty(value="noMoreBufferIds") boolean noMoreBufferIds) {
        super(version);
        this.type = Objects.requireNonNull(type, "type is null");
        this.buffers = ImmutableMap.copyOf(Objects.requireNonNull(buffers, "buffers is null"));
        this.noMoreBufferIds = noMoreBufferIds;
    }

    @JsonProperty
    public BufferType getType() {
        return this.type;
    }

    @JsonProperty
    public Map<OutputBufferId, Integer> getBuffers() {
        return this.buffers;
    }

    @JsonProperty
    public boolean isNoMoreBufferIds() {
        return this.noMoreBufferIds;
    }

    @Override
    public void checkValidTransition(OutputBuffers outputBuffers) {
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Preconditions.checkArgument((boolean)(outputBuffers instanceof PipelinedOutputBuffers), (Object)"outputBuffers is expected to be an instance of PipelinedOutputBuffers");
        PipelinedOutputBuffers newOutputBuffers = (PipelinedOutputBuffers)outputBuffers;
        Preconditions.checkState((this.type == newOutputBuffers.getType() ? 1 : 0) != 0, (String)"newOutputBuffers has a different type %s, expected %s", (Object)((Object)newOutputBuffers.getType()), (Object)((Object)this.type));
        if (this.noMoreBufferIds) {
            Preconditions.checkArgument((boolean)this.equals(newOutputBuffers), (Object)"Expected buffer to not change after no more buffers is set");
            return;
        }
        if (this.getVersion() > newOutputBuffers.getVersion()) {
            throw new IllegalArgumentException("newOutputBuffers version is older");
        }
        if (this.getVersion() == newOutputBuffers.getVersion()) {
            Preconditions.checkArgument((boolean)this.equals(newOutputBuffers), (Object)"newOutputBuffers is the same version but contains different information");
        }
        for (Map.Entry<OutputBufferId, Integer> entry : this.buffers.entrySet()) {
            if (entry.getValue().equals(newOutputBuffers.getBuffers().get(entry.getKey()))) continue;
            throw new IllegalArgumentException("newOutputBuffers has changed the assignment for task " + entry.getKey());
        }
    }

    public PipelinedOutputBuffers withBuffer(OutputBufferId bufferId, int partition) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        if (this.buffers.containsKey(bufferId)) {
            this.checkHasBuffer(bufferId, partition);
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        return new PipelinedOutputBuffers(this.getVersion() + 1L, this.type, (Map<OutputBufferId, Integer>)ImmutableMap.builder().putAll(this.buffers).put((Object)bufferId, (Object)partition).buildOrThrow(), false);
    }

    public PipelinedOutputBuffers withBuffers(Map<OutputBufferId, Integer> buffers) {
        Objects.requireNonNull(buffers, "buffers is null");
        HashMap<OutputBufferId, Integer> newBuffers = new HashMap<OutputBufferId, Integer>();
        for (Map.Entry<OutputBufferId, Integer> entry : buffers.entrySet()) {
            OutputBufferId bufferId = entry.getKey();
            int partition = entry.getValue();
            if (this.buffers.containsKey(bufferId)) {
                this.checkHasBuffer(bufferId, partition);
                continue;
            }
            newBuffers.put(bufferId, partition);
        }
        if (newBuffers.isEmpty()) {
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        newBuffers.putAll(this.buffers);
        return new PipelinedOutputBuffers(this.getVersion() + 1L, this.type, newBuffers, false);
    }

    public PipelinedOutputBuffers withNoMoreBufferIds() {
        if (this.noMoreBufferIds) {
            return this;
        }
        return new PipelinedOutputBuffers(this.getVersion() + 1L, this.type, this.buffers, true);
    }

    private void checkHasBuffer(OutputBufferId bufferId, int partition) {
        Preconditions.checkArgument((boolean)Objects.equals(this.buffers.get(bufferId), partition), (String)"OutputBuffers already contains task %s, but partition is set to %s not %s", (Object)bufferId, (Object)this.buffers.get(bufferId), (Object)partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelinedOutputBuffers that = (PipelinedOutputBuffers)o;
        return this.getVersion() == that.getVersion() && this.noMoreBufferIds == that.noMoreBufferIds && this.type == that.type && this.buffers.equals(that.buffers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getVersion(), this.type, this.buffers, this.noMoreBufferIds});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.getVersion()).add("type", (Object)this.type).add("buffers", this.buffers).add("noMoreBufferIds", this.noMoreBufferIds).toString();
    }

    public static enum BufferType {
        PARTITIONED,
        BROADCAST,
        ARBITRARY;

    }

    public static class OutputBufferId {
        private final int id;

        public static OutputBufferId fromString(String id) {
            return new OutputBufferId(Integer.parseInt(id));
        }

        @JsonCreator
        public OutputBufferId(int id) {
            Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputBufferId that = (OutputBufferId)o;
            return this.id == that.id;
        }

        @JsonValue
        public int getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return String.valueOf(this.id);
        }
    }
}

