/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.scheduler.PipelinedOutputBufferManager;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class BroadcastPipelinedOutputBufferManager
implements PipelinedOutputBufferManager {
    @GuardedBy(value="this")
    private PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial(PipelinedOutputBuffers.BufferType.BROADCAST);

    BroadcastPipelinedOutputBufferManager() {
    }

    @Override
    public synchronized void addOutputBuffer(PipelinedOutputBuffers.OutputBufferId newBuffer) {
        if (this.outputBuffers.isNoMoreBufferIds()) {
            return;
        }
        PipelinedOutputBuffers newOutputBuffers = this.outputBuffers.withBuffer(newBuffer, 0);
        if (newOutputBuffers != this.outputBuffers) {
            this.outputBuffers = newOutputBuffers;
        }
    }

    @Override
    public synchronized void noMoreBuffers() {
        if (!this.outputBuffers.isNoMoreBufferIds()) {
            this.outputBuffers = this.outputBuffers.withNoMoreBufferIds();
        }
    }

    @Override
    public synchronized PipelinedOutputBuffers getOutputBuffers() {
        return this.outputBuffers;
    }
}

