/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;

public final class BucketNodeMap {
    private final List<InternalNode> bucketToNode;
    private final ToIntFunction<Split> splitToBucket;

    public BucketNodeMap(ToIntFunction<Split> splitToBucket, List<InternalNode> bucketToNode) {
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
        this.bucketToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketToNode, "bucketToNode is null"));
    }

    public int getBucketCount() {
        return this.bucketToNode.size();
    }

    public int getBucket(Split split) {
        return this.splitToBucket.applyAsInt(split);
    }

    public InternalNode getAssignedNode(int bucketId) {
        return this.bucketToNode.get(bucketId);
    }

    public InternalNode getAssignedNode(Split split) {
        return this.getAssignedNode(this.getBucket(split));
    }

    public ToIntFunction<Split> getSplitToBucketFunction() {
        return this.splitToBucket;
    }
}

