/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public abstract class IrAccessor
extends IrPathNode {
    protected final IrPathNode base;

    IrAccessor(IrPathNode base, Optional<Type> type) {
        super(type);
        this.base = Objects.requireNonNull(base, "accessor base is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrAccessor(this, context);
    }

    @JsonProperty
    public IrPathNode getBase() {
        return this.base;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrAccessor other = (IrAccessor)obj;
        return Objects.equals(this.base, other.base);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base);
    }
}

