/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.block.Block;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.util.Objects;
import java.util.Optional;

public class IrLiteral
extends IrPathNode {
    private final Object value;

    public IrLiteral(Type type, Object value) {
        super(Optional.of(type));
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Deprecated
    @JsonCreator
    public static IrLiteral fromJson(@JsonProperty(value="type") Type type, @JsonProperty(value="valueAsBlock") Block value) {
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0);
        return new IrLiteral(type, TypeUtils.readNativeValue((Type)type, (Block)value, (int)0));
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrLiteral(this, context);
    }

    @JsonIgnore
    public Object getValue() {
        return this.value;
    }

    @JsonProperty
    public Block getValueAsBlock() {
        return Utils.nativeValueToBlock((Type)this.getType().orElseThrow(), (Object)this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrLiteral other = (IrLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.getType(), other.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.getType());
    }
}

