/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PageBufferClientStatus;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.spi.Mergeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DirectExchangeClientStatus
implements Mergeable<DirectExchangeClientStatus>,
OperatorInfo {
    private final long bufferedBytes;
    private final long maxBufferedBytes;
    private final long averageBytesPerRequest;
    private final long successfulRequestsCount;
    private final int bufferedPages;
    private final int spilledPages;
    private final long spilledBytes;
    private final boolean noMoreLocations;
    private final List<PageBufferClientStatus> pageBufferClientStatuses;
    private final TDigestHistogram requestDuration;

    @JsonCreator
    public DirectExchangeClientStatus(@JsonProperty(value="bufferedBytes") long bufferedBytes, @JsonProperty(value="maxBufferedBytes") long maxBufferedBytes, @JsonProperty(value="averageBytesPerRequest") long averageBytesPerRequest, @JsonProperty(value="successfulRequestsCount") long successFullRequestsCount, @JsonProperty(value="bufferedPages") int bufferedPages, @JsonProperty(value="spilledPages") int spilledPages, @JsonProperty(value="spilledBytes") long spilledBytes, @JsonProperty(value="noMoreLocations") boolean noMoreLocations, @JsonProperty(value="pageBufferClientStatuses") List<PageBufferClientStatus> pageBufferClientStatuses, @JsonProperty(value="requestDuration") TDigestHistogram requestDuration) {
        this.bufferedBytes = bufferedBytes;
        this.maxBufferedBytes = maxBufferedBytes;
        this.averageBytesPerRequest = averageBytesPerRequest;
        this.successfulRequestsCount = successFullRequestsCount;
        this.bufferedPages = bufferedPages;
        this.spilledPages = spilledPages;
        this.spilledBytes = spilledBytes;
        this.noMoreLocations = noMoreLocations;
        this.pageBufferClientStatuses = ImmutableList.copyOf((Collection)Objects.requireNonNull(pageBufferClientStatuses, "pageBufferClientStatuses is null"));
        this.requestDuration = Objects.requireNonNull(requestDuration, "requestsDuration is null");
    }

    @JsonProperty
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    @JsonProperty
    public long getMaxBufferedBytes() {
        return this.maxBufferedBytes;
    }

    @JsonProperty
    public long getAverageBytesPerRequest() {
        return this.averageBytesPerRequest;
    }

    @JsonProperty
    public long getSuccessfulRequestsCount() {
        return this.successfulRequestsCount;
    }

    @JsonProperty
    public int getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    public int getSpilledPages() {
        return this.spilledPages;
    }

    @JsonProperty
    public long getSpilledBytes() {
        return this.spilledBytes;
    }

    @JsonProperty
    public boolean isNoMoreLocations() {
        return this.noMoreLocations;
    }

    @JsonProperty
    public List<PageBufferClientStatus> getPageBufferClientStatuses() {
        return this.pageBufferClientStatuses;
    }

    @JsonProperty
    public TDigestHistogram getRequestDuration() {
        return this.requestDuration;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bufferBytes", this.bufferedBytes).add("maxBufferedBytes", this.maxBufferedBytes).add("averageBytesPerRequest", this.averageBytesPerRequest).add("successfulRequestsCount", this.successfulRequestsCount).add("bufferedPages", this.bufferedPages).add("spilledPages", this.spilledPages).add("spilledBytes", this.spilledBytes).add("noMoreLocations", this.noMoreLocations).add("pageBufferClientStatuses", this.pageBufferClientStatuses).add("requestDuration", (Object)this.requestDuration).toString();
    }

    public DirectExchangeClientStatus mergeWith(DirectExchangeClientStatus other) {
        return new DirectExchangeClientStatus((this.bufferedBytes + other.bufferedBytes) / 2L, Math.max(this.maxBufferedBytes, other.maxBufferedBytes), DirectExchangeClientStatus.mergeAvgs(this.averageBytesPerRequest, this.successfulRequestsCount, other.averageBytesPerRequest, other.successfulRequestsCount), this.successfulRequestsCount + other.successfulRequestsCount, this.bufferedPages + other.bufferedPages, this.spilledPages + other.spilledPages, this.spilledBytes + other.spilledBytes, this.noMoreLocations && other.noMoreLocations, (List<PageBufferClientStatus>)ImmutableList.of(), this.requestDuration.mergeWith(other.requestDuration));
    }

    private static long mergeAvgs(long value1, long count1, long value2, long count2) {
        if (count1 == 0L) {
            return value2;
        }
        if (count2 == 0L) {
            return value1;
        }
        return value1 * count1 / (count1 + count2) + value2 * count2 / (count1 + count2);
    }
}

