/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.SyntheticAddress;
import io.trino.operator.join.PagesHash;
import io.trino.operator.join.PositionLinks;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class DefaultPagesHash
implements PagesHash {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DefaultPagesHash.class);
    private static final DataSize CACHE_SIZE = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private final LongArrayList addresses;
    private final PagesHashStrategy pagesHashStrategy;
    private final int mask;
    private final int[] keys;
    private final long size;
    private final byte[] positionToHashes;

    public static long getEstimatedRetainedSizeInBytes(int positionCount, HashArraySizeSupplier hashArraySizeSupplier, LongArrayList addresses, List<ObjectArrayList<Block>> channels, long blocksSizeInBytes) {
        return SizeOf.sizeOf((long[])addresses.elements()) + (channels.size() > 0 ? SizeOf.sizeOf((Object[])channels.get(0).elements()) * (long)channels.size() : 0L) + blocksSizeInBytes + SizeOf.sizeOfIntArray((int)hashArraySizeSupplier.getHashArraySize(positionCount)) + SizeOf.sizeOfByteArray((int)positionCount);
    }

    public DefaultPagesHash(LongArrayList addresses, PagesHashStrategy pagesHashStrategy, PositionLinks.FactoryBuilder positionLinks, HashArraySizeSupplier hashArraySizeSupplier) {
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.pagesHashStrategy = Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        int hashSize = hashArraySizeSupplier.getHashArraySize(addresses.size());
        this.mask = hashSize - 1;
        this.keys = new int[hashSize];
        Arrays.fill(this.keys, -1);
        this.positionToHashes = new byte[addresses.size()];
        int positionsInStep = Math.min(addresses.size() + 1, (int)CACHE_SIZE.toBytes() / 32);
        long[] positionToFullHashes = new long[positionsInStep];
        int step = 0;
        while (step * positionsInStep <= addresses.size()) {
            long hash;
            int stepBeginPosition = step * positionsInStep;
            int stepEndPosition = Math.min((step + 1) * positionsInStep, addresses.size());
            int stepSize = stepEndPosition - stepBeginPosition;
            for (int batchIndex = 0; batchIndex < stepSize; ++batchIndex) {
                int addressIndex = batchIndex + stepBeginPosition;
                positionToFullHashes[batchIndex] = hash = this.readHashPosition(addressIndex);
                this.positionToHashes[addressIndex] = (byte)hash;
            }
            for (int position = 0; position < stepSize; ++position) {
                int realPosition = position + stepBeginPosition;
                if (this.isPositionNull(realPosition)) continue;
                hash = positionToFullHashes[position];
                int pos = PagesHash.getHashPosition(hash, this.mask);
                while (this.keys[pos] != -1) {
                    int currentKey = this.keys[pos];
                    if ((byte)hash == this.positionToHashes[currentKey] && this.positionEqualsPositionIgnoreNulls(currentKey, realPosition)) {
                        realPosition = positionLinks.link(realPosition, currentKey);
                        break;
                    }
                    pos = pos + 1 & this.mask;
                }
                this.keys[pos] = realPosition;
            }
            ++step;
        }
        this.size = SizeOf.sizeOf((long[])addresses.elements()) + pagesHashStrategy.getSizeInBytes() + SizeOf.sizeOf((int[])this.keys) + SizeOf.sizeOf((byte[])this.positionToHashes);
    }

    @Override
    public int getPositionCount() {
        return this.addresses.size();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return (long)INSTANCE_SIZE + this.size;
    }

    @Override
    public int getAddressIndex(int position, Page hashChannelsPage) {
        return this.getAddressIndex(position, hashChannelsPage, this.pagesHashStrategy.hashRow(position, hashChannelsPage));
    }

    @Override
    public int getAddressIndex(int rightPosition, Page hashChannelsPage, long rawHash) {
        int pos = PagesHash.getHashPosition(rawHash, this.mask);
        while (this.keys[pos] != -1) {
            if (this.positionEqualsCurrentRowIgnoreNulls(this.keys[pos], (byte)rawHash, rightPosition, hashChannelsPage)) {
                return this.keys[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return -1;
    }

    @Override
    public int[] getAddressIndex(int[] positions, Page hashChannelsPage) {
        long[] hashes = new long[positions[positions.length - 1] + 1];
        for (int i = 0; i < positions.length; ++i) {
            hashes[positions[i]] = this.pagesHashStrategy.hashRow(positions[i], hashChannelsPage);
        }
        return this.getAddressIndex(positions, hashChannelsPage, hashes);
    }

    @Override
    public int[] getAddressIndex(int[] positions, Page hashChannelsPage, long[] rawHashes) {
        int index;
        int i;
        int i2;
        int positionCount = positions.length;
        int[] hashPositions = new int[positionCount];
        for (int i3 = 0; i3 < positionCount; ++i3) {
            hashPositions[i3] = PagesHash.getHashPosition(rawHashes[positions[i3]], this.mask);
        }
        int[] found = new int[positionCount];
        int foundCount = 0;
        int[] result = new int[positionCount];
        Arrays.fill(result, -1);
        int[] foundKeys = new int[positionCount];
        for (i2 = 0; i2 < positionCount; ++i2) {
            foundKeys[i2] = this.keys[hashPositions[i2]];
        }
        for (i2 = 0; i2 < positionCount; ++i2) {
            if (foundKeys[i2] == -1) continue;
            found[foundCount++] = i2;
        }
        int[] remaining = found;
        int remainingCount = 0;
        for (i = 0; i < foundCount; ++i) {
            index = found[i];
            if (this.positionEqualsCurrentRowIgnoreNulls(foundKeys[index], (byte)rawHashes[positions[index]], positions[index], hashChannelsPage)) {
                result[index] = foundKeys[index];
                continue;
            }
            remaining[remainingCount++] = index;
        }
        block4: for (i = 0; i < remainingCount; ++i) {
            index = remaining[i];
            int position = hashPositions[index] + 1 & this.mask;
            while (this.keys[position] != -1) {
                if (this.positionEqualsCurrentRowIgnoreNulls(this.keys[position], (byte)rawHashes[positions[index]], positions[index], hashChannelsPage)) {
                    result[index] = this.keys[position];
                    continue block4;
                }
                position = position + 1 & this.mask;
            }
        }
        return result;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        long pageAddress = this.addresses.getLong(Math.toIntExact(position));
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        this.pagesHashStrategy.appendTo(blockIndex, blockPosition, pageBuilder, outputChannelOffset);
    }

    private boolean isPositionNull(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.isPositionNull(blockIndex, blockPosition);
    }

    private long readHashPosition(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.hashPosition(blockIndex, blockPosition);
    }

    private boolean positionEqualsCurrentRowIgnoreNulls(int leftPosition, byte rawHash, int rightPosition, Page rightPage) {
        if (this.positionToHashes[leftPosition] != rawHash) {
            return false;
        }
        long pageAddress = this.addresses.getLong(leftPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.positionEqualsRowIgnoreNulls(blockIndex, blockPosition, rightPosition, rightPage);
    }

    private boolean positionEqualsPositionIgnoreNulls(int leftPosition, int rightPosition) {
        long leftPageAddress = this.addresses.getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = this.addresses.getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        return this.pagesHashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
    }
}

