/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.VarArgsToArrayAdapterGenerator;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ArrayConcatFunction
extends SqlScalarFunction {
    public static final ArrayConcatFunction ARRAY_CONCAT_FUNCTION = new ArrayConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final String DESCRIPTION = "Concatenates given arrays";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayConcatFunction.class, "concat", Type.class, Object.class, Block[].class);
    private static final MethodHandle USER_STATE_FACTORY = Reflection.methodHandle(ArrayConcatFunction.class, "createState", Type.class);

    private ArrayConcatFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(FUNCTION_NAME).typeVariable("E").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).variableArity().build()).description(DESCRIPTION).build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        if (boundSignature.getArity() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more arguments to concat");
        }
        ArrayType arrayType = (ArrayType)boundSignature.getReturnType();
        VarArgsToArrayAdapterGenerator.MethodHandleAndConstructor methodHandleAndConstructor = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Block.class, Block.class, boundSignature.getArity(), METHOD_HANDLE.bindTo(arrayType.getElementType()), USER_STATE_FACTORY.bindTo(arrayType.getElementType()));
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandleAndConstructor.getMethodHandle(), Optional.of(methodHandleAndConstructor.getConstructor()));
    }

    @UsedByGeneratedCode
    public static Object createState(Type elementType) {
        return new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @UsedByGeneratedCode
    public static Block concat(Type elementType, Object state, Block[] blocks) {
        int resultPositionCount = 0;
        Block nonEmptyBlock = null;
        for (int i = 0; i < blocks.length; ++i) {
            resultPositionCount += blocks[i].getPositionCount();
            if (blocks[i].getPositionCount() <= 0) continue;
            nonEmptyBlock = blocks[i];
        }
        if (nonEmptyBlock == null) {
            return blocks[0];
        }
        if (resultPositionCount == nonEmptyBlock.getPositionCount()) {
            return nonEmptyBlock;
        }
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
        for (int blockIndex = 0; blockIndex < blocks.length; ++blockIndex) {
            Block block = blocks[blockIndex];
            for (int i = 0; i < block.getPositionCount(); ++i) {
                elementType.appendTo(block, i, blockBuilder);
            }
        }
        pageBuilder.declarePositions(resultPositionCount);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - resultPositionCount, resultPositionCount);
    }
}

