/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;

public final class ConcatWsFunction
extends SqlScalarFunction {
    public static final ConcatWsFunction CONCAT_WS = new ConcatWsFunction();
    private static final int MAX_INPUT_VALUES = 254;
    private static final int MAX_OUTPUT_LENGTH = 0x100000;

    public ConcatWsFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("concat_ws").returnType((Type)VarcharType.VARCHAR).argumentType((Type)VarcharType.VARCHAR).argumentType((Type)VarcharType.VARCHAR).variableArity().build()).argumentNullability(new boolean[]{false, true}).description("Concatenates elements using separator").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        int valueCount = boundSignature.getArity() - 1;
        if (valueCount < 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more arguments");
        }
        MethodHandle arrayMethodHandle = Reflection.methodHandle(ConcatWsFunction.class, "concatWs", Slice.class, Slice[].class);
        MethodHandle customMethodHandle = arrayMethodHandle.asCollector(Slice[].class, valueCount);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.builder().add((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL).addAll(Collections.nCopies(valueCount, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE)).build(), customMethodHandle);
    }

    @UsedByGeneratedCode
    public static Slice concatWs(Slice separator, final Slice[] values) {
        return ConcatWsFunction.concatWs(separator, new SliceArray(){

            @Override
            public Slice getElement(int i) {
                return values[i];
            }

            @Override
            public int getCount() {
                return values.length;
            }
        });
    }

    private static Slice concatWs(Slice separator, SliceArray values) {
        if (values.getCount() > 254) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for string concatenation");
        }
        int length = 0;
        boolean requiresSeparator = false;
        for (int i = 0; i < values.getCount(); ++i) {
            Slice value = values.getElement(i);
            if (value == null) continue;
            if (requiresSeparator) {
                length = Math.addExact(length, separator.length());
            }
            length = Math.addExact(length, value.length());
            requiresSeparator = true;
            if (length <= 0x100000) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
        Slice result = Slices.allocate((int)length);
        int position = 0;
        requiresSeparator = false;
        for (int i = 0; i < values.getCount(); ++i) {
            Slice value = values.getElement(i);
            if (value == null) continue;
            if (requiresSeparator) {
                result.setBytes(position, separator);
                position += separator.length();
            }
            result.setBytes(position, value);
            position += value.length();
            requiresSeparator = true;
        }
        return result;
    }

    private static interface SliceArray {
        public Slice getElement(int var1);

        public int getCount();
    }

    @ScalarFunction(value="concat_ws")
    public static final class ConcatArrayWs {
        @SqlType(value="varchar")
        public static Slice concatWsArray(@SqlType(value="varchar") Slice separator, final @SqlType(value="array(varchar)") Block elements) {
            return ConcatWsFunction.concatWs(separator, new SliceArray(){

                @Override
                public Slice getElement(int i) {
                    if (elements.isNull(i)) {
                        return null;
                    }
                    int sliceLength = elements.getSliceLength(i);
                    return elements.getSlice(i, 0, sliceLength);
                }

                @Override
                public int getCount() {
                    return elements.getPositionCount();
                }
            });
        }
    }
}

