/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.trino.execution.AddColumnTask;
import io.trino.execution.CallTask;
import io.trino.execution.CommentTask;
import io.trino.execution.CommitTask;
import io.trino.execution.CreateCatalogTask;
import io.trino.execution.CreateMaterializedViewTask;
import io.trino.execution.CreateRoleTask;
import io.trino.execution.CreateSchemaTask;
import io.trino.execution.CreateTableTask;
import io.trino.execution.CreateViewTask;
import io.trino.execution.DataDefinitionExecution;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.DeallocateTask;
import io.trino.execution.DenyTask;
import io.trino.execution.DropCatalogTask;
import io.trino.execution.DropColumnTask;
import io.trino.execution.DropMaterializedViewTask;
import io.trino.execution.DropRoleTask;
import io.trino.execution.DropSchemaTask;
import io.trino.execution.DropTableTask;
import io.trino.execution.DropViewTask;
import io.trino.execution.GrantRolesTask;
import io.trino.execution.GrantTask;
import io.trino.execution.PrepareTask;
import io.trino.execution.QueryExecution;
import io.trino.execution.RenameColumnTask;
import io.trino.execution.RenameMaterializedViewTask;
import io.trino.execution.RenameSchemaTask;
import io.trino.execution.RenameTableTask;
import io.trino.execution.RenameViewTask;
import io.trino.execution.ResetSessionTask;
import io.trino.execution.RevokeRolesTask;
import io.trino.execution.RevokeTask;
import io.trino.execution.RollbackTask;
import io.trino.execution.SetColumnTypeTask;
import io.trino.execution.SetPathTask;
import io.trino.execution.SetPropertiesTask;
import io.trino.execution.SetRoleTask;
import io.trino.execution.SetSchemaAuthorizationTask;
import io.trino.execution.SetSessionTask;
import io.trino.execution.SetTableAuthorizationTask;
import io.trino.execution.SetTimeZoneTask;
import io.trino.execution.SetViewAuthorizationTask;
import io.trino.execution.SqlQueryExecution;
import io.trino.execution.StartTransactionTask;
import io.trino.execution.TruncateTableTask;
import io.trino.execution.UseTask;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Use;
import io.trino.util.StatementUtils;

public class QueryExecutionFactoryModule
implements Module {
    public void configure(Binder binder) {
        MapBinder executionBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<QueryExecution.QueryExecutionFactory<?>>(){});
        binder.bind(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        for (Class<? extends Statement> statement : StatementUtils.getNonDataDefinitionStatements()) {
            executionBinder.addBinding(statement).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        }
        binder.bind(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, AddColumn.class, AddColumnTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Call.class, CallTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Comment.class, CommentTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Commit.class, CommitTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateCatalog.class, CreateCatalogTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateRole.class, CreateRoleTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateSchema.class, CreateSchemaTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateTable.class, CreateTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateView.class, CreateViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Deallocate.class, DeallocateTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Deny.class, DenyTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropCatalog.class, DropCatalogTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropColumn.class, DropColumnTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropRole.class, DropRoleTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropSchema.class, DropSchemaTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropTable.class, DropTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropView.class, DropViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, TruncateTable.class, TruncateTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateMaterializedView.class, CreateMaterializedViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropMaterializedView.class, DropMaterializedViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Grant.class, GrantTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, GrantRoles.class, GrantRolesTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Prepare.class, PrepareTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameColumn.class, RenameColumnTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameMaterializedView.class, RenameMaterializedViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameSchema.class, RenameSchemaTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameTable.class, RenameTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameView.class, RenameViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, ResetSession.class, ResetSessionTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Revoke.class, RevokeTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RevokeRoles.class, RevokeRolesTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Rollback.class, RollbackTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetColumnType.class, SetColumnTypeTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetPath.class, SetPathTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetProperties.class, SetPropertiesTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetTimeZone.class, SetTimeZoneTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetRole.class, SetRoleTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetSchemaAuthorization.class, SetSchemaAuthorizationTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetSession.class, SetSessionTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetTableAuthorization.class, SetTableAuthorizationTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetViewAuthorization.class, SetViewAuthorizationTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, StartTransaction.class, StartTransactionTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Use.class, UseTask.class);
    }

    private static <T extends Statement> void bindDataDefinitionTask(Binder binder, MapBinder<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionBinder, Class<T> statement, Class<? extends DataDefinitionTask<T>> task) {
        Preconditions.checkArgument((boolean)StatementUtils.isDataDefinitionStatement(statement));
        MapBinder taskBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<DataDefinitionTask<?>>(){});
        taskBinder.addBinding(statement).to(task).in(Scopes.SINGLETON);
        executionBinder.addBinding(statement).to(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
    }
}

