/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.trino.server.security.oauth2.OAuth2Client;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public interface TokenPairSerializer {
    public static final TokenPairSerializer ACCESS_TOKEN_ONLY_SERIALIZER = new TokenPairSerializer(){

        @Override
        public TokenPair deserialize(String token) {
            return TokenPair.accessToken(token);
        }

        @Override
        public String serialize(TokenPair tokenPair) {
            return tokenPair.getAccessToken();
        }
    };

    public TokenPair deserialize(String var1);

    public String serialize(TokenPair var1);

    public static class TokenPair {
        private final String accessToken;
        private final Date expiration;
        private final Optional<String> refreshToken;

        private TokenPair(String accessToken, Date expiration, Optional<String> refreshToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken is nul");
            this.expiration = Objects.requireNonNull(expiration, "expiration is null");
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken is null");
        }

        public static TokenPair accessToken(String accessToken) {
            return new TokenPair(accessToken, new Date(Long.MAX_VALUE), Optional.empty());
        }

        public static TokenPair fromOAuth2Response(OAuth2Client.Response tokens) {
            Objects.requireNonNull(tokens, "tokens is null");
            return new TokenPair(tokens.getAccessToken(), Date.from(tokens.getExpiration()), tokens.getRefreshToken());
        }

        public static TokenPair accessAndRefreshTokens(String accessToken, Date expiration, @Nullable String refreshToken) {
            return new TokenPair(accessToken, expiration, Optional.ofNullable(refreshToken));
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Optional<String> getRefreshToken() {
            return this.refreshToken;
        }
    }
}

