/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.primitives.Ints;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MappedPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final int[] delegateFieldIndex;

    public MappedPageSource(ConnectorPageSource delegate, List<Integer> delegateFieldIndex) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.delegateFieldIndex = Ints.toArray((Collection)Objects.requireNonNull(delegateFieldIndex, "delegateFieldIndex is null"));
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        Page nextPage = this.delegate.getNextPage();
        if (nextPage == null) {
            return null;
        }
        return nextPage.getColumns(this.delegateFieldIndex);
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

