/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.StatementAnalyzer;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Analyzer {
    private final AnalyzerFactory analyzerFactory;
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final Session session;
    private final List<Expression> parameters;
    private final Map<NodeRef<Parameter>, Expression> parameterLookup;
    private final WarningCollector warningCollector;
    private final StatementRewrite statementRewrite;

    Analyzer(Session session, AnalyzerFactory analyzerFactory, StatementAnalyzerFactory statementAnalyzerFactory, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, StatementRewrite statementRewrite) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.parameters = parameters;
        this.parameterLookup = parameterLookup;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.statementRewrite = Objects.requireNonNull(statementRewrite, "statementRewrite is null");
    }

    public Analysis analyze(Statement statement) {
        return this.analyze(statement, QueryType.OTHERS);
    }

    public Analysis analyze(Statement statement, QueryType queryType) {
        Statement rewrittenStatement = this.statementRewrite.rewrite(this.analyzerFactory, this.session, statement, this.parameters, this.parameterLookup, this.warningCollector);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameterLookup, queryType);
        StatementAnalyzer analyzer = this.statementAnalyzerFactory.createStatementAnalyzer(analysis, this.session, this.warningCollector, CorrelationSupport.ALLOWED);
        analyzer.analyze((Node)rewrittenStatement, Optional.empty());
        analysis.getTableColumnReferences().forEach((accessControlInfo, tableColumnReferences) -> tableColumnReferences.forEach((tableName, columns) -> accessControlInfo.getAccessControl().checkCanSelectFromColumns(accessControlInfo.getSecurityContext(this.session.getRequiredTransactionId(), this.session.getQueryId()), (QualifiedObjectName)tableName, (Set<String>)columns)));
        return analysis;
    }

    static void verifyNoAggregateWindowOrGroupingFunctions(Session session, Metadata metadata, Expression predicate, String clause) {
        List<GroupingOperation> groupingOperations;
        List<Expression> windowExpressions;
        List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), session, metadata);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(aggregates, windowExpressions = ExpressionTreeUtils.extractWindowExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate)), groupingOperations = ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), GroupingOperation.class)));
        if (!found.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_SCALAR, (Node)predicate, "%s cannot contain aggregations, window functions or grouping operations: %s", clause, found);
        }
    }
}

