/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogProperties;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProperties;
import io.trino.operator.RetryPolicy;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCodeSupplier;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SchedulingOrderVisitor;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PlanFragmenter {
    private static final String TOO_MANY_STAGES_MESSAGE = "If the query contains multiple aggregates with DISTINCT over different columns, please set the 'use_mark_distinct' session property to false. If the query contains WITH clauses that are referenced more than once, please create temporary table(s) for the queries in those clauses.";
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final TransactionManager transactionManager;
    private final CatalogManager catalogManager;
    private final int stageCountWarningThreshold;

    @Inject
    public PlanFragmenter(Metadata metadata, FunctionManager functionManager, TransactionManager transactionManager, CatalogManager catalogManager, QueryManagerConfig queryManagerConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.catalogManager = Objects.requireNonNull(catalogManager, "catalogManager is null");
        this.stageCountWarningThreshold = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null").getStageCountWarningThreshold();
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode, WarningCollector warningCollector) {
        List activeCatalogs = (List)this.transactionManager.getActiveCatalogs(session.getTransactionId().orElseThrow()).stream().map(CatalogInfo::getCatalogHandle).flatMap(catalogHandle -> this.catalogManager.getCatalogProperties((CatalogHandle)catalogHandle).stream()).collect(ImmutableList.toImmutableList());
        Fragmenter fragmenter = new Fragmenter(session, this.metadata, this.functionManager, plan.getTypes(), plan.getStatsAndCosts(), activeCatalogs);
        FragmentProperties properties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getRoot().getOutputSymbols()));
        if (forceSingleNode || SystemSessionProperties.isForceSingleNodeOutput(session)) {
            properties = properties.setSingleNodeDistribution();
        }
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan subPlan = fragmenter.buildRootFragment(root, properties);
        subPlan = this.reassignPartitioningHandleIfNecessary(session, subPlan);
        Preconditions.checkState((!SystemSessionProperties.isForceSingleNodeOutput(session) || subPlan.getFragment().getPartitioning().isSingleNode() ? 1 : 0) != 0, (Object)"Root of PlanFragment is not single node");
        this.sanityCheckFragmentedPlan(subPlan, warningCollector, SystemSessionProperties.getQueryMaxStageCount(session), this.stageCountWarningThreshold);
        return subPlan;
    }

    private void sanityCheckFragmentedPlan(SubPlan subPlan, WarningCollector warningCollector, int maxStageCount, int stageCountSoftLimit) {
        subPlan.sanityCheck();
        int fragmentCount = subPlan.getAllFragments().size();
        if (fragmentCount > maxStageCount) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_HAS_TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the allowed maximum (%s). %s", fragmentCount, maxStageCount, TOO_MANY_STAGES_MESSAGE));
        }
        if (fragmentCount > stageCountSoftLimit) {
            warningCollector.add(new TrinoWarning((WarningCodeSupplier)StandardWarningCode.TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the soft limit (%s). %s", fragmentCount, stageCountSoftLimit, TOO_MANY_STAGES_MESSAGE)));
        }
    }

    private SubPlan reassignPartitioningHandleIfNecessary(Session session, SubPlan subPlan) {
        return this.reassignPartitioningHandleIfNecessaryHelper(session, subPlan, subPlan.getFragment().getPartitioning());
    }

    private SubPlan reassignPartitioningHandleIfNecessaryHelper(Session session, SubPlan subPlan, PartitioningHandle newOutputPartitioningHandle) {
        PlanFragment fragment = subPlan.getFragment();
        PlanNode newRoot = fragment.getRoot();
        if (!fragment.getPartitioning().isSingleNode()) {
            PartitioningHandleReassigner partitioningHandleReassigner = new PartitioningHandleReassigner(fragment.getPartitioning(), this.metadata, session);
            newRoot = SimplePlanRewriter.rewriteWith(partitioningHandleReassigner, newRoot);
        }
        PartitioningScheme outputPartitioningScheme = fragment.getOutputPartitioningScheme();
        Partitioning newOutputPartitioning = outputPartitioningScheme.getPartitioning();
        if (outputPartitioningScheme.getPartitioning().getHandle().getCatalogHandle().isPresent()) {
            newOutputPartitioning = newOutputPartitioning.withAlternativePartitioningHandle(newOutputPartitioningHandle);
        }
        PlanFragment newFragment = new PlanFragment(fragment.getId(), newRoot, fragment.getSymbols(), fragment.getPartitioning(), fragment.getPartitionCount(), fragment.getPartitionedSources(), new PartitioningScheme(newOutputPartitioning, outputPartitioningScheme.getOutputLayout(), outputPartitioningScheme.getHashColumn(), outputPartitioningScheme.isReplicateNullsAndAny(), outputPartitioningScheme.getBucketToPartition(), outputPartitioningScheme.getPartitionCount()), fragment.getStatsAndCosts(), fragment.getActiveCatalogs(), fragment.getJsonRepresentation());
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            childrenBuilder.add((Object)this.reassignPartitioningHandleIfNecessaryHelper(session, child, fragment.getPartitioning()));
        }
        return new SubPlan(newFragment, (List<SubPlan>)childrenBuilder.build());
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private static final int ROOT_FRAGMENT_ID = 0;
        private final Session session;
        private final Metadata metadata;
        private final FunctionManager functionManager;
        private final TypeProvider types;
        private final StatsAndCosts statsAndCosts;
        private final List<CatalogProperties> activeCatalogs;
        private int nextFragmentId = 1;

        public Fragmenter(Session session, Metadata metadata, FunctionManager functionManager, TypeProvider types, StatsAndCosts statsAndCosts, List<CatalogProperties> activeCatalogs) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
            this.activeCatalogs = Objects.requireNonNull(activeCatalogs, "activeCatalogs is null");
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(String.valueOf(0)));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            Set<Symbol> dependencies = SymbolsExtractor.extractOutputSymbols(root);
            List<PlanNodeId> schedulingOrder = SchedulingOrderVisitor.scheduleOrder(root);
            boolean equals = properties.getPartitionedSources().equals(ImmutableSet.copyOf(schedulingOrder));
            Preconditions.checkArgument((boolean)equals, (String)"Expected scheduling order (%s) to contain an entry for all partitioned sources (%s)", schedulingOrder, properties.getPartitionedSources());
            Map symbols = Maps.filterKeys(this.types.allTypes(), (Predicate)Predicates.in(dependencies));
            PlanFragment fragment = new PlanFragment(fragmentId, root, symbols, properties.getPartitioningHandle(), properties.getPartitionCount(), schedulingOrder, properties.getPartitioningScheme(), this.statsAndCosts.getForSubplan(root), this.activeCatalogs, Optional.of(PlanPrinter.jsonFragmentPlan(root, symbols, this.metadata, this.functionManager, this.session)));
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                context.get().setSingleNodeDistribution();
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSimpleTableExecuteNode(SimpleTableExecuteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableDelete(TableDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PartitioningHandle partitioning = this.metadata.getTableProperties(this.session, node.getTable()).getTablePartitioning().filter(value -> node.isUseConnectorNodePartitioning()).map(TableProperties.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            context.get().addSourceDistribution(node.getId(), partitioning, this.metadata, this.session);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitRefreshMaterializedView(RefreshMaterializedViewNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            node.getPartitioningScheme().ifPresent(scheme -> ((FragmentProperties)context.get()).setDistribution(scheme.getPartitioning().getHandle(), scheme.getPartitionCount(), this.metadata, this.session));
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableExecute(TableExecuteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            node.getPartitioningScheme().ifPresent(scheme -> ((FragmentProperties)context.get()).setDistribution(scheme.getPartitioning().getHandle(), scheme.getPartitionCount(), this.metadata, this.session));
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMergeWriter(MergeWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            node.getPartitioningScheme().ifPresent(scheme -> ((FragmentProperties)context.get()).setDistribution(scheme.getPartitioning().getHandle(), scheme.getPartitionCount(), this.metadata, this.session));
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (node.getRowCount() != 0 || !context.get().hasDistribution()) {
                context.get().setSingleNodeDistribution();
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFunction(TableFunctionNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            throw new IllegalStateException(String.format("Unexpected node: TableFunctionNode (%s)", node.getName()));
        }

        @Override
        public PlanNode visitTableFunctionProcessor(TableFunctionProcessorNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (node.getSource().isEmpty()) {
                context.get().addSourceDistribution(node.getId(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, this.metadata, this.session);
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (exchange.getScope() != ExchangeNode.Scope.REMOTE) {
                return context.defaultRewrite(exchange, context.get());
            }
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setDistribution(partitioningScheme.getPartitioning().getHandle(), partitioningScheme.getPartitionCount(), this.metadata, this.session);
            }
            ImmutableList.Builder childrenProperties = ImmutableList.builder();
            ImmutableList.Builder childrenBuilder = ImmutableList.builder();
            for (int sourceIndex = 0; sourceIndex < exchange.getSources().size(); ++sourceIndex) {
                FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout(exchange.getInputs().get(sourceIndex)));
                childrenProperties.add((Object)childProperties);
                childrenBuilder.add((Object)this.buildSubPlan(exchange.getSources().get(sourceIndex), childProperties, context));
            }
            ImmutableList children = childrenBuilder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols(), exchange.getOrderingScheme(), exchange.getType(), Fragmenter.isWorkerCoordinatorBoundary(context.get(), (List<FragmentProperties>)childrenProperties.build()) ? SystemSessionProperties.getRetryPolicy(this.session) : RetryPolicy.NONE);
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }

        private static boolean isWorkerCoordinatorBoundary(FragmentProperties fragmentProperties, List<FragmentProperties> childFragmentsProperties) {
            if (!fragmentProperties.getPartitioningHandle().isCoordinatorOnly()) {
                return false;
            }
            if (childFragmentsProperties.stream().allMatch(properties -> properties.getPartitioningHandle().isCoordinatorOnly())) {
                return false;
            }
            Preconditions.checkArgument((boolean)childFragmentsProperties.stream().noneMatch(properties -> properties.getPartitioningHandle().isCoordinatorOnly()), (Object)"Plans are not expected to have a mix of coordinator only fragments and distributed fragments as siblings");
            return true;
        }
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitioningScheme partitioningScheme;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private Optional<Integer> partitionCount = Optional.empty();
        private final Set<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();

        public FragmentProperties(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public boolean hasDistribution() {
            return this.partitioningHandle.isPresent();
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((boolean)this.partitioningHandle.isEmpty(), (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution, Optional<Integer> partitionCount, Metadata metadata, Session session) {
            if (this.partitioningHandle.isEmpty()) {
                this.partitioningHandle = Optional.of(distribution);
                this.partitionCount = partitionCount;
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            if (currentPartitioning.isSingleNode()) {
                return this;
            }
            if (this.isCompatibleSystemPartitioning(distribution)) {
                return this;
            }
            if (FragmentProperties.isCompatibleScaledWriterPartitioning(currentPartitioning, distribution)) {
                this.partitioningHandle = Optional.of(distribution);
                this.partitionCount = partitionCount;
                return this;
            }
            if (currentPartitioning.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            throw new IllegalStateException(String.format("Cannot set distribution to %s. Already set to %s", distribution, this.partitioningHandle));
        }

        private boolean isCompatibleSystemPartitioning(PartitioningHandle distribution) {
            ConnectorPartitioningHandle currentHandle = this.partitioningHandle.get().getConnectorHandle();
            ConnectorPartitioningHandle distributionHandle = distribution.getConnectorHandle();
            if (currentHandle instanceof SystemPartitioningHandle && distributionHandle instanceof SystemPartitioningHandle) {
                return ((SystemPartitioningHandle)currentHandle).getPartitioning() == ((SystemPartitioningHandle)distributionHandle).getPartitioning();
            }
            return false;
        }

        private static boolean isCompatibleScaledWriterPartitioning(PartitioningHandle current, PartitioningHandle suggested) {
            if (current.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) && suggested.equals(SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION)) {
                return true;
            }
            PartitioningHandle currentWithScaledWritersEnabled = new PartitioningHandle(current.getCatalogHandle(), current.getTransactionHandle(), current.getConnectorHandle(), true);
            return currentWithScaledWritersEnabled.equals(suggested);
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((this.partitioningHandle.isEmpty() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addSourceDistribution(PlanNodeId source, PartitioningHandle distribution, Metadata metadata, Session session) {
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(distribution, "distribution is null");
            this.partitionedSources.add(source);
            if (this.partitioningHandle.isEmpty()) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (currentPartitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || currentPartitioning.equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
                return this;
            }
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            throw new IllegalStateException(String.format("Cannot overwrite distribution with %s (currently set to %s)", distribution, currentPartitioning));
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitioningScheme;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public Optional<Integer> getPartitionCount() {
            return this.partitionCount;
        }

        public Set<PlanNodeId> getPartitionedSources() {
            return this.partitionedSources;
        }
    }

    private static final class PartitioningHandleReassigner
    extends SimplePlanRewriter<Void> {
        private final PartitioningHandle fragmentPartitioningHandle;
        private final Metadata metadata;
        private final Session session;

        public PartitioningHandleReassigner(PartitioningHandle fragmentPartitioningHandle, Metadata metadata, Session session) {
            this.fragmentPartitioningHandle = fragmentPartitioningHandle;
            this.metadata = metadata;
            this.session = session;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PartitioningHandle partitioning = this.metadata.getTableProperties(this.session, node.getTable()).getTablePartitioning().filter(value -> node.isUseConnectorNodePartitioning()).map(TableProperties.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            if (partitioning.equals(this.fragmentPartitioningHandle)) {
                return node;
            }
            TableHandle newTable = this.metadata.makeCompatiblePartitioning(this.session, node.getTable(), this.fragmentPartitioningHandle);
            return new TableScanNode(node.getId(), newTable, node.getOutputSymbols(), node.getAssignments(), node.getEnforcedConstraint(), node.getStatistics(), node.isUpdateTarget(), node.getUseConnectorNodePartitioning());
        }
    }
}

