/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.PartialTranslator;
import io.trino.sql.planner.ReferenceAwareExpressionNodeInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class PushProjectionIntoTableScan
implements Rule<ProjectNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;
    private final LiteralEncoder literalEncoder;
    private final ScalarStatsCalculator scalarStatsCalculator;

    public PushProjectionIntoTableScan(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, ScalarStatsCalculator scalarStatsCalculator) {
        this.plannerContext = plannerContext;
        this.typeAnalyzer = typeAnalyzer;
        this.literalEncoder = new LiteralEncoder(plannerContext);
        this.scalarStatsCalculator = Objects.requireNonNull(scalarStatsCalculator, "scalarStatsCalculator is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Session session = context.getSession();
        Map partialTranslations = (Map)project.getAssignments().getMap().entrySet().stream().flatMap(expression -> PartialTranslator.extractPartialTranslations((Expression)expression.getValue(), session, this.typeAnalyzer, context.getSymbolAllocator().getTypes(), this.plannerContext).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (first, ignore) -> first));
        ImmutableList nodesForPartialProjections = ImmutableList.copyOf(partialTranslations.keySet());
        ImmutableList connectorPartialProjections = ImmutableList.copyOf(partialTranslations.values());
        Map inputVariableMappings = (Map)tableScan.getAssignments().keySet().stream().collect(ImmutableMap.toImmutableMap(Symbol::getName, Function.identity()));
        Map assignments = (Map)inputVariableMappings.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> tableScan.getAssignments().get(entry.getValue())));
        Optional<ProjectionApplicationResult<TableHandle>> result = this.plannerContext.getMetadata().applyProjection(session, tableScan.getTable(), (List<ConnectorExpression>)connectorPartialProjections, assignments);
        if (result.isEmpty()) {
            return Rule.Result.empty();
        }
        List newConnectorPartialProjections = result.get().getProjections();
        Preconditions.checkState((newConnectorPartialProjections.size() == connectorPartialProjections.size() ? 1 : 0) != 0, (String)"Mismatch between input and output projections from the connector: expected %s but got %s", (int)connectorPartialProjections.size(), (int)newConnectorPartialProjections.size());
        ArrayList<Symbol> newScanOutputs = new ArrayList<Symbol>();
        HashMap<Symbol, ColumnHandle> newScanAssignments = new HashMap<Symbol, ColumnHandle>();
        HashMap<String, Symbol> variableMappings = new HashMap<String, Symbol>();
        for (Assignment assignment : result.get().getAssignments()) {
            Symbol symbol = context.getSymbolAllocator().newSymbol(assignment.getVariable(), assignment.getType());
            newScanOutputs.add(symbol);
            newScanAssignments.put(symbol, assignment.getColumn());
            variableMappings.put(assignment.getVariable(), symbol);
        }
        List newPartialProjections = (List)newConnectorPartialProjections.stream().map(expression -> {
            Expression translated = ConnectorExpressionTranslator.translate(session, expression, this.plannerContext, variableMappings, this.literalEncoder);
            Map<NodeRef<Expression>, Type> translatedExpressionTypes = this.typeAnalyzer.getTypes(session, context.getSymbolAllocator().getTypes(), translated);
            translated = this.literalEncoder.toExpression(session, new ExpressionInterpreter(translated, this.plannerContext, session, translatedExpressionTypes).optimize(NoOpSymbolResolver.INSTANCE), translatedExpressionTypes.get(NodeRef.of((Node)translated)));
            return translated;
        }).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder nodesToNewPartialProjectionsBuilder = ImmutableMap.builder();
        for (int i = 0; i < nodesForPartialProjections.size(); ++i) {
            nodesToNewPartialProjectionsBuilder.put((Object)((NodeRef)nodesForPartialProjections.get(i)), (Object)((Expression)newPartialProjections.get(i)));
        }
        ImmutableMap nodesToNewPartialProjections = nodesToNewPartialProjectionsBuilder.buildOrThrow();
        Assignments.Builder newProjectionAssignments = Assignments.builder();
        project.getAssignments().entrySet().forEach(arg_0 -> PushProjectionIntoTableScan.lambda$apply$4(newProjectionAssignments, (Map)nodesToNewPartialProjections, arg_0));
        Optional<PlanNodeStatsEstimate> newStatistics = tableScan.getStatistics().map(arg_0 -> this.lambda$apply$5((List)connectorPartialProjections, newConnectorPartialProjections, session, inputVariableMappings, context, variableMappings, arg_0));
        this.verifyTablePartitioning(context, tableScan, (TableHandle)result.get().getHandle());
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new TableScanNode(tableScan.getId(), (TableHandle)result.get().getHandle(), newScanOutputs, newScanAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), newStatistics, tableScan.isUpdateTarget(), tableScan.getUseConnectorNodePartitioning()), newProjectionAssignments.build()));
    }

    private void verifyTablePartitioning(Rule.Context context, TableScanNode oldTableScan, TableHandle newTable) {
        if (oldTableScan.getUseConnectorNodePartitioning().isEmpty()) {
            return;
        }
        Optional<TableProperties.TablePartitioning> oldTablePartitioning = this.plannerContext.getMetadata().getTableProperties(context.getSession(), oldTableScan.getTable()).getTablePartitioning();
        Optional<TableProperties.TablePartitioning> newTablePartitioning = this.plannerContext.getMetadata().getTableProperties(context.getSession(), newTable).getTablePartitioning();
        Verify.verify((boolean)newTablePartitioning.equals(oldTablePartitioning), (String)"Partitioning must not change after projection is pushed down", (Object[])new Object[0]);
    }

    private /* synthetic */ PlanNodeStatsEstimate lambda$apply$5(List connectorPartialProjections, List newConnectorPartialProjections, Session session, Map inputVariableMappings, Rule.Context context, Map variableMappings, PlanNodeStatsEstimate statistics) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder();
        builder.setOutputRowCount(statistics.getOutputRowCount());
        for (int i = 0; i < connectorPartialProjections.size(); ++i) {
            ConnectorExpression inputConnectorExpression = (ConnectorExpression)connectorPartialProjections.get(i);
            ConnectorExpression resultConnectorExpression = (ConnectorExpression)newConnectorPartialProjections.get(i);
            if (!(resultConnectorExpression instanceof Variable)) continue;
            String resultVariableName = ((Variable)resultConnectorExpression).getName();
            Expression inputExpression = ConnectorExpressionTranslator.translate(session, inputConnectorExpression, this.plannerContext, inputVariableMappings, this.literalEncoder);
            SymbolStatsEstimate symbolStatistics = this.scalarStatsCalculator.calculate(inputExpression, statistics, session, context.getSymbolAllocator().getTypes());
            builder.addSymbolStatistics((Symbol)variableMappings.get(resultVariableName), symbolStatistics);
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$apply$4(Assignments.Builder newProjectionAssignments, Map nodesToNewPartialProjections, Map.Entry entry) {
        newProjectionAssignments.put((Symbol)entry.getKey(), ReferenceAwareExpressionNodeInliner.replaceExpression((Expression)entry.getValue(), nodesToNewPartialProjections));
    }
}

