/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MergeWriterNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.MergeTarget target;
    private final List<Symbol> projectedSymbols;
    private final Optional<PartitioningScheme> partitioningScheme;
    private final List<Symbol> outputs;

    @JsonCreator
    public MergeWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.MergeTarget target, @JsonProperty(value="projectedSymbols") List<Symbol> projectedSymbols, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> partitioningScheme, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.projectedSymbols = Objects.requireNonNull(projectedSymbols, "projectedSymbols is null");
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        this.outputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.MergeTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public List<Symbol> getProjectedSymbols() {
        return this.projectedSymbols;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMergeWriter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new MergeWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.projectedSymbols, this.partitioningScheme, this.outputs);
    }
}

