/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.trino.block.BlockAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;

public final class SequencePageBuilder {
    private SequencePageBuilder() {
    }

    public static Page createSequencePage(List<? extends Type> types, int length) {
        return SequencePageBuilder.createSequencePage(types, length, new int[types.size()]);
    }

    public static Page createSequencePage(List<? extends Type> types, int length, int ... initialValues) {
        Block[] blocks = new Block[initialValues.length];
        for (int i = 0; i < blocks.length; ++i) {
            DecimalType decimalType;
            DecimalType decimalType2;
            Type type = types.get(i);
            int initialValue = initialValues[i];
            if (type.equals(BigintType.BIGINT)) {
                blocks[i] = BlockAssertions.createLongSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(RealType.REAL)) {
                blocks[i] = BlockAssertions.createSequenceBlockOfReal(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                blocks[i] = BlockAssertions.createDoubleSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type instanceof VarcharType) {
                blocks[i] = BlockAssertions.createStringSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                blocks[i] = BlockAssertions.createBooleanSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(DateType.DATE)) {
                blocks[i] = BlockAssertions.createDateSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
                blocks[i] = BlockAssertions.createTimestampSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type instanceof DecimalType && (decimalType2 = (DecimalType)type).isShort()) {
                blocks[i] = BlockAssertions.createShortDecimalSequenceBlock(initialValue, initialValue + length, decimalType2);
                continue;
            }
            if (type instanceof DecimalType && !(decimalType = (DecimalType)type).isShort()) {
                blocks[i] = BlockAssertions.createLongDecimalSequenceBlock(initialValue, initialValue + length, decimalType);
                continue;
            }
            throw new IllegalStateException("Unsupported type " + type);
        }
        return new Page(blocks);
    }

    public static Page createSequencePageWithDictionaryBlocks(List<? extends Type> types, int length) {
        return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, length, new int[types.size()]);
    }

    public static Page createSequencePageWithDictionaryBlocks(List<? extends Type> types, int length, int ... initialValues) {
        Block[] blocks = new Block[initialValues.length];
        for (int i = 0; i < blocks.length; ++i) {
            Type type = types.get(i);
            int initialValue = initialValues[i];
            if (type.equals(VarcharType.VARCHAR)) {
                blocks[i] = BlockAssertions.createStringDictionaryBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(BigintType.BIGINT)) {
                blocks[i] = BlockAssertions.createLongDictionaryBlock(initialValue, initialValue + length);
                continue;
            }
            throw new IllegalStateException("Unsupported type " + type);
        }
        return new Page(blocks);
    }
}

