/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.util.MoreMath;

public final class EstimateAssertion {
    private static final double TOLERANCE = 1.0E-7;

    private EstimateAssertion() {
    }

    public static void assertEstimateEquals(double actual, double expected, String messageFormat, Object ... messageObjects) {
        if (Double.isNaN(actual) && Double.isNaN(expected)) {
            return;
        }
        if (!MoreMath.nearlyEqual((double)actual, (double)expected, (double)1.0E-7)) {
            throw new AssertionError((Object)(String.format(messageFormat, messageObjects) + String.format(", expected [%f], but got [%f]", expected, actual)));
        }
    }
}

