/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.CreateCatalogTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.LocalQueryRunner;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateCatalogTask {
    private static final String TEST_CATALOG = "test_catalog";
    private static final ImmutableList<Property> TPCH_PROPERTIES = ImmutableList.of((Object)new Property(new Identifier("tpch.partitioning-enabled"), (Expression)new StringLiteral("false")));
    protected LocalQueryRunner queryRunner;
    private QueryStateMachine queryStateMachine;

    @BeforeMethod
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.queryRunner.registerCatalogFactory((ConnectorFactory)new TpchConnectorFactory());
        this.queryRunner.registerCatalogFactory((ConnectorFactory)new FailConnectorFactory());
        this.queryStateMachine = QueryStateMachine.begin(Optional.empty(), (String)"test", Optional.empty(), (Session)this.queryRunner.getDefaultSession(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.queryRunner.getTransactionManager(), (AccessControl)this.queryRunner.getAccessControl(), (Executor)MoreExecutors.directExecutor(), (Metadata)this.queryRunner.getMetadata(), (WarningCollector)WarningCollector.NOOP, Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }

    @AfterMethod
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
        this.queryRunner = null;
    }

    @Test
    public void testDuplicatedCreateCatalog() {
        CreateCatalogTask task = this.getCreateCatalogTask();
        CreateCatalog statement = new CreateCatalog(new Identifier(TEST_CATALOG), false, new Identifier("tpch"), TPCH_PROPERTIES, Optional.empty(), Optional.empty());
        MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.queryRunner.getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG));
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("Catalog '%s' already exists", new Object[]{TEST_CATALOG});
    }

    @Test
    public void testDuplicatedCreateCatalogIfNotExists() {
        CreateCatalogTask task = this.getCreateCatalogTask();
        CreateCatalog statement = new CreateCatalog(new Identifier(TEST_CATALOG), true, new Identifier("tpch"), TPCH_PROPERTIES, Optional.empty(), Optional.empty());
        MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.queryRunner.getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG));
        MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.queryRunner.getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG));
    }

    @Test
    public void failCreateCatalog() {
        CreateCatalogTask task = this.getCreateCatalogTask();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(new CreateCatalog(new Identifier(TEST_CATALOG), true, new Identifier("fail"), (List)ImmutableList.of(), Optional.empty(), Optional.empty()), this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessageContaining("TEST create catalog fail: test_catalog");
    }

    private CreateCatalogTask getCreateCatalogTask() {
        return new CreateCatalogTask(this.queryRunner.getPlannerContext(), (AccessControl)new AllowAllAccessControl(), this.queryRunner.getCatalogManager());
    }

    private static class FailConnectorFactory
    implements ConnectorFactory {
        private FailConnectorFactory() {
        }

        public String getName() {
            return "fail";
        }

        public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
            throw new IllegalArgumentException("TEST create catalog fail: " + catalogName);
        }
    }
}

