/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.execution.DynamicFilterConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestDynamicFilterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DynamicFilterConfig)ConfigAssertions.recordDefaults(DynamicFilterConfig.class)).setEnableDynamicFiltering(true).setEnableCoordinatorDynamicFiltersDistribution(true).setEnableLargeDynamicFilters(false).setSmallBroadcastMaxDistinctValuesPerDriver(200).setSmallBroadcastMaxSizePerDriver(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallBroadcastRangeRowLimitPerDriver(400).setSmallPartitionedMaxDistinctValuesPerDriver(20).setSmallBroadcastMaxSizePerOperator(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallPartitionedMaxSizePerDriver(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallPartitionedRangeRowLimitPerDriver(100).setSmallPartitionedMaxSizePerOperator(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallMaxSizePerFilter(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setLargeBroadcastMaxDistinctValuesPerDriver(5000).setLargeBroadcastMaxSizePerDriver(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargeBroadcastRangeRowLimitPerDriver(10000).setLargeBroadcastMaxSizePerOperator(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setLargePartitionedMaxDistinctValuesPerDriver(500).setLargePartitionedMaxSizePerDriver(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargePartitionedRangeRowLimitPerDriver(1000).setLargePartitionedMaxSizePerOperator(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargeMaxSizePerFilter(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"enable-dynamic-filtering", (Object)"false").put((Object)"enable-coordinator-dynamic-filters-distribution", (Object)"false").put((Object)"enable-large-dynamic-filters", (Object)"true").put((Object)"dynamic-filtering.small-broadcast.max-distinct-values-per-driver", (Object)"256").put((Object)"dynamic-filtering.small-broadcast.max-size-per-driver", (Object)"64kB").put((Object)"dynamic-filtering.small-broadcast.range-row-limit-per-driver", (Object)"10000").put((Object)"dynamic-filtering.small-broadcast.max-size-per-operator", (Object)"640kB").put((Object)"dynamic-filtering.small-partitioned.max-distinct-values-per-driver", (Object)"256").put((Object)"dynamic-filtering.small-partitioned.max-size-per-driver", (Object)"64kB").put((Object)"dynamic-filtering.small-partitioned.range-row-limit-per-driver", (Object)"10000").put((Object)"dynamic-filtering.small-partitioned.max-size-per-operator", (Object)"641kB").put((Object)"dynamic-filtering.small.max-size-per-filter", (Object)"341kB").put((Object)"dynamic-filtering.large-broadcast.max-distinct-values-per-driver", (Object)"256").put((Object)"dynamic-filtering.large-broadcast.max-size-per-driver", (Object)"64kB").put((Object)"dynamic-filtering.large-broadcast.range-row-limit-per-driver", (Object)"100000").put((Object)"dynamic-filtering.large-broadcast.max-size-per-operator", (Object)"642kB").put((Object)"dynamic-filtering.large-partitioned.max-distinct-values-per-driver", (Object)"256").put((Object)"dynamic-filtering.large-partitioned.max-size-per-driver", (Object)"64kB").put((Object)"dynamic-filtering.large-partitioned.range-row-limit-per-driver", (Object)"100000").put((Object)"dynamic-filtering.large-partitioned.max-size-per-operator", (Object)"643kB").put((Object)"dynamic-filtering.large.max-size-per-filter", (Object)"3411kB").buildOrThrow();
        DynamicFilterConfig expected = new DynamicFilterConfig().setEnableDynamicFiltering(false).setEnableCoordinatorDynamicFiltersDistribution(false).setEnableLargeDynamicFilters(true).setSmallBroadcastMaxDistinctValuesPerDriver(256).setSmallBroadcastMaxSizePerDriver(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallBroadcastRangeRowLimitPerDriver(10000).setSmallBroadcastMaxSizePerOperator(DataSize.of((long)640L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallPartitionedMaxDistinctValuesPerDriver(256).setSmallPartitionedMaxSizePerDriver(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallPartitionedRangeRowLimitPerDriver(10000).setSmallPartitionedMaxSizePerOperator(DataSize.of((long)641L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setSmallMaxSizePerFilter(DataSize.of((long)341L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargeBroadcastMaxDistinctValuesPerDriver(256).setLargeBroadcastMaxSizePerDriver(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargeBroadcastRangeRowLimitPerDriver(100000).setLargeBroadcastMaxSizePerOperator(DataSize.of((long)642L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargePartitionedMaxDistinctValuesPerDriver(256).setLargePartitionedMaxSizePerDriver(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargePartitionedRangeRowLimitPerDriver(100000).setLargePartitionedMaxSizePerOperator(DataSize.of((long)643L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLargeMaxSizePerFilter(DataSize.of((long)3411L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

