/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlStage;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSplit;
import io.trino.util.FinalizerService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSqlStage {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newFixedThreadPool(100, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test(timeOut=120000L)
    public void testFinalStageInfo() throws Exception {
        for (int iteration = 0; iteration < 10; ++iteration) {
            this.testFinalStageInfoInternal();
        }
    }

    private void testFinalStageInfoInternal() throws Exception {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(new FinalizerService());
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStage stage = SqlStage.createSqlStage((StageId)stageId, (PlanFragment)TestSqlStage.createExchangePlanFragment(), (Map)ImmutableMap.of(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.executor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (Executor)this.executor, (SplitSchedulerStats)new SplitSchedulerStats());
        SettableFuture finalStageInfo = SettableFuture.create();
        stage.addFinalStageInfoListener(arg_0 -> ((SettableFuture)finalStageInfo).set(arg_0));
        CompletableFuture stopped = new CompletableFuture();
        CountDownLatch countDownLatch = new CountDownLatch(1000);
        List createdTasks = Collections.synchronizedList(new ArrayList(2000));
        Future<?> addTasksTask = this.executor.submit(() -> {
            try {
                PlanNodeId planNodeId = (PlanNodeId)stage.getFragment().getPartitionedSources().get(0);
                ImmutableListMultimap initialSplits = ImmutableListMultimap.of((Object)planNodeId, (Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingSplit(true, (List)ImmutableList.of())));
                for (int i = 0; i < 1000000; ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    InternalNode node = new InternalNode("source" + i, URI.create("http://10.0.0." + i / 10000 + ":" + i % 10000), NodeVersion.UNKNOWN, false);
                    Optional created = stage.createTask(node, i, 0, Optional.empty(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.ARBITRARY), (Multimap)initialSplits, (Set)ImmutableSet.of(), Optional.empty());
                    if (!created.isPresent()) continue;
                    Object patt6562$temp = created.get();
                    if (patt6562$temp instanceof MockRemoteTaskFactory.MockRemoteTask) {
                        MockRemoteTaskFactory.MockRemoteTask mockTask = (MockRemoteTaskFactory.MockRemoteTask)patt6562$temp;
                        mockTask.start();
                        mockTask.startSplits(1);
                        createdTasks.add(mockTask);
                        countDownLatch.countDown();
                        continue;
                    }
                    Assert.fail((String)"Expected an instance of MockRemoteTask");
                }
            }
            finally {
                while (countDownLatch.getCount() > 0L) {
                    countDownLatch.countDown();
                }
                stopped.complete(null);
            }
        });
        countDownLatch.await();
        stage.finish();
        Assert.assertTrue((createdTasks.size() >= 1000 ? 1 : 0) != 0);
        StageInfo stageInfo = stage.getStageInfo();
        for (TaskInfo info : stageInfo.getTasks()) {
            TaskState taskState = info.getTaskStatus().getState();
            int runningSplits = info.getTaskStatus().getRunningPartitionedDrivers();
            if (runningSplits == 0) {
                Assert.assertTrue((taskState == TaskState.CANCELING || taskState == TaskState.CANCELED ? 1 : 0) != 0, (String)("unexpected task state: " + taskState));
                continue;
            }
            Assert.assertEquals((Object)taskState, (Object)TaskState.CANCELING);
            Assert.assertTrue((runningSplits > 0 ? 1 : 0) != 0, (String)"must be running splits to not be already canceled");
        }
        Assert.assertFalse((boolean)finalStageInfo.isDone());
        addTasksTask.cancel(true);
        stopped.join();
        createdTasks.forEach(task -> {
            task.clearSplits();
            Assert.assertEquals((Object)task.getTaskStatus().getState(), (Object)TaskState.CANCELED);
        });
        stageInfo = (StageInfo)finalStageInfo.get(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stageInfo.getTasks().isEmpty());
        Assert.assertTrue((boolean)stageInfo.isFinalStageInfo());
        Assert.assertSame((Object)stage.getStageInfo(), (Object)stageInfo);
    }

    private static PlanFragment createExchangePlanFragment() {
        RemoteSourceNode planNode = new RemoteSourceNode(new PlanNodeId("exchange"), (List)ImmutableList.of((Object)new PlanFragmentId("source")), (List)ImmutableList.of((Object)new Symbol("column")), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE);
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (Symbol symbol : planNode.getOutputSymbols()) {
            types.put((Object)symbol, (Object)VarcharType.VARCHAR);
        }
        return new PlanFragment(new PlanFragmentId("exchange_fragment_id"), (PlanNode)planNode, (Map)types.buildOrThrow(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), planNode.getOutputSymbols()), StatsAndCosts.empty(), (List)ImmutableList.of(), Optional.empty());
    }
}

