/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.stats.TDigest;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.StageStats;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.spi.eventlistener.StageGcStatistics;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStageStats {
    private static final StageStats EXPECTED = new StageStats(new DateTime(0L), TestStageStats.getTestDistribution(1), 4, 5, 6, 1, 7, 8, 10, 26, 11, 12.0, 13.0, DataSize.ofBytes((long)14L), DataSize.ofBytes((long)15L), DataSize.ofBytes((long)16L), DataSize.ofBytes((long)17L), DataSize.ofBytes((long)18L), new Duration(19.0, TimeUnit.NANOSECONDS), new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(22.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)191L), DataSize.ofBytes((long)192L), 201L, 202L, new Duration(24.0, TimeUnit.NANOSECONDS), new Duration(25.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)193L), DataSize.ofBytes((long)194L), 203L, 204L, DataSize.ofBytes((long)26L), DataSize.ofBytes((long)27L), 28L, 29L, DataSize.ofBytes((long)30L), DataSize.ofBytes((long)31L), 32L, 33L, new Duration(201.0, TimeUnit.NANOSECONDS), new Duration(202.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)34L), Optional.of(TestStageStats.getTDigestHistogram(10)), DataSize.ofBytes((long)35L), DataSize.ofBytes((long)36L), 37L, 38L, new Duration(203.0, TimeUnit.NANOSECONDS), new Duration(204.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)39L), DataSize.ofBytes((long)40L), new StageGcStatistics(101, 102, 103, 104, 105, 106, 107), (List)ImmutableList.of());

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(StageStats.class);
        String json = codec.toJson((Object)EXPECTED);
        StageStats actual = (StageStats)codec.fromJson(json);
        TestStageStats.assertExpectedStageStats(actual);
    }

    private static void assertExpectedStageStats(StageStats actual) {
        Assert.assertEquals((long)actual.getSchedulingComplete().getMillis(), (long)0L);
        Assert.assertEquals((Object)actual.getGetSplitDistribution().getCount(), (Object)1.0);
        Assert.assertEquals((int)actual.getTotalTasks(), (int)4);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)5);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)6);
        Assert.assertEquals((int)actual.getFailedTasks(), (int)1);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)10);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)26);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)11);
        Assert.assertEquals((Object)actual.getCumulativeUserMemory(), (Object)12.0);
        Assert.assertEquals((Object)actual.getFailedCumulativeUserMemory(), (Object)13.0);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)14L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)15L));
        Assert.assertEquals((Object)actual.getTotalMemoryReservation(), (Object)DataSize.ofBytes((long)16L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)17L));
        Assert.assertEquals((Object)actual.getPeakRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)18L));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(19.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFailedScheduledTime(), (Object)new Duration(20.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(21.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFailedCpuTime(), (Object)new Duration(22.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(23.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)191L));
        Assert.assertEquals((Object)actual.getFailedPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)192L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)201L);
        Assert.assertEquals((long)actual.getFailedPhysicalInputPositions(), (long)202L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(24.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFailedPhysicalInputReadTime(), (Object)new Duration(25.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)193L));
        Assert.assertEquals((Object)actual.getFailedInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)194L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)203L);
        Assert.assertEquals((long)actual.getFailedInternalNetworkInputPositions(), (long)204L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)26L));
        Assert.assertEquals((Object)actual.getFailedRawInputDataSize(), (Object)DataSize.ofBytes((long)27L));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)28L);
        Assert.assertEquals((long)actual.getFailedRawInputPositions(), (long)29L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)DataSize.ofBytes((long)30L));
        Assert.assertEquals((Object)actual.getFailedProcessedInputDataSize(), (Object)DataSize.ofBytes((long)31L));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)32L);
        Assert.assertEquals((long)actual.getFailedProcessedInputPositions(), (long)33L);
        Assert.assertEquals((Object)actual.getInputBlockedTime(), (Object)new Duration(201.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFailedInputBlockedTime(), (Object)new Duration(202.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getBufferedDataSize(), (Object)DataSize.ofBytes((long)34L));
        Assert.assertEquals((Object)((TDigestHistogram)actual.getOutputBufferUtilization().get()).getMax(), (Object)9.0);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)35L));
        Assert.assertEquals((Object)actual.getFailedOutputDataSize(), (Object)DataSize.ofBytes((long)36L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)37L);
        Assert.assertEquals((long)actual.getFailedOutputPositions(), (long)38L);
        Assert.assertEquals((Object)actual.getOutputBlockedTime(), (Object)new Duration(203.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFailedOutputBlockedTime(), (Object)new Duration(204.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)39L));
        Assert.assertEquals((Object)actual.getFailedPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)40L));
        Assert.assertEquals((int)actual.getGcInfo().getStageId(), (int)101);
        Assert.assertEquals((int)actual.getGcInfo().getTasks(), (int)102);
        Assert.assertEquals((int)actual.getGcInfo().getFullGcTasks(), (int)103);
        Assert.assertEquals((int)actual.getGcInfo().getMinFullGcSec(), (int)104);
        Assert.assertEquals((int)actual.getGcInfo().getMaxFullGcSec(), (int)105);
        Assert.assertEquals((int)actual.getGcInfo().getTotalFullGcSec(), (int)106);
        Assert.assertEquals((int)actual.getGcInfo().getAverageFullGcSec(), (int)107);
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }

    private static TDigestHistogram getTDigestHistogram(int count) {
        TDigest digest = new TDigest();
        for (int i = 0; i < count; ++i) {
            digest.add((double)i);
        }
        return new TDigestHistogram(digest);
    }
}

