/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.scheduler.PartitionedPipelinedOutputBufferManager;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionedPipelinedOutputBufferManager {
    @Test
    public void test() {
        PartitionedPipelinedOutputBufferManager hashOutputBufferManager = new PartitionedPipelinedOutputBufferManager(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 4);
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(0));
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(3));
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(5))).isInstanceOf(IllegalStateException.class)).hasMessage("Unexpected new output buffer 5");
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hashOutputBufferManager.addOutputBuffer(new PipelinedOutputBuffers.OutputBufferId(6))).isInstanceOf(IllegalStateException.class)).hasMessage("Unexpected new output buffer 6");
        TestPartitionedPipelinedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
    }

    private static void assertOutputBuffers(PipelinedOutputBuffers outputBuffers) {
        Assert.assertNotNull((Object)outputBuffers);
        Assert.assertTrue((outputBuffers.getVersion() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)outputBuffers.isNoMoreBufferIds());
        Map buffers = outputBuffers.getBuffers();
        Assert.assertEquals((int)buffers.size(), (int)4);
        for (int partition = 0; partition < 4; ++partition) {
            Assert.assertEquals(buffers.get(new PipelinedOutputBuffers.OutputBufferId(partition)), (Object)partition);
        }
    }
}

