/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureDeserializer;
import java.util.Collection;
import java.util.Map;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignature {
    @Test
    public void testSerializationRoundTrip() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER), TypeSignature.class, (Object)new TypeSignatureDeserializer()));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider, true).jsonCodec(Signature.class);
        Signature expected = Signature.builder().name("function").returnType((Type)BigintType.BIGINT).argumentType((Type)BooleanType.BOOLEAN).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)VarcharType.VARCHAR).build();
        String json = codec.toJson((Object)expected);
        Signature actual = (Signature)codec.fromJson(json);
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((Object)actual.getReturnType(), (Object)expected.getReturnType());
        Assert.assertEquals((Collection)actual.getArgumentTypes(), (Collection)expected.getArgumentTypes());
    }
}

