/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.operator.CyclingGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=4)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkGroupedTopNRowNumberBuilder {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int SHIP_DATE = 2;
    private static final int QUANTITY = 3;

    @Benchmark
    public List<Page> topN(BenchmarkData data) {
        data.getTopNBuilder().processPage(data.getPage()).process();
        return ImmutableList.copyOf((Iterator)data.getTopNBuilder().buildResult());
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkGroupedTopNRowNumberBuilder().topN(data);
        Benchmarks.benchmark(BenchmarkGroupedTopNRowNumberBuilder.class).run();
    }

    private static Page createInputPage(int positions, List<Type> types) {
        PageBuilder pageBuilder = new PageBuilder(types);
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < positions; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.getExtendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getDiscount());
            DateType.DATE.writeLong(pageBuilder.getBlockBuilder(2), (long)lineItem.getShipDate());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), (double)lineItem.getQuantity());
        }
        return pageBuilder.build();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final List<Type> types = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE);
        private final PageWithPositionComparator comparator = new SimplePageWithPositionComparator(this.types, (List)ImmutableList.of((Object)0, (Object)2), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_FIRST), new TypeOperators());
        @Param(value={"1", "10", "100"})
        private String topN = "1";
        @Param(value={"10000", "1000000"})
        private String positions = "1";
        @Param(value={"1", "10000", "1000000"})
        private String groupCount = "1";
        private Page page;
        private GroupedTopNRowNumberBuilder topNBuilder;

        @Setup(value=Level.Invocation)
        public void setup() {
            this.page = BenchmarkGroupedTopNRowNumberBuilder.createInputPage(Integer.valueOf(this.positions), this.types);
            this.topNBuilder = new GroupedTopNRowNumberBuilder(this.types, this.comparator, Integer.valueOf(this.topN).intValue(), false, (GroupByHash)new CyclingGroupByHash(Integer.valueOf(this.groupCount)));
        }

        public GroupedTopNBuilder getTopNBuilder() {
            return this.topNBuilder;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

