/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.CyclingGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCyclingGroupByHash {
    @Test
    public void testSingleGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(1);
        Page page = TestCyclingGroupByHash.createPage(1);
        GroupByIdBlock groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)1L);
        page = TestCyclingGroupByHash.createPage(2);
        groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)1L);
    }

    @Test
    public void testMultipleGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(2);
        Page page = TestCyclingGroupByHash.createPage(3);
        GroupByIdBlock groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L, 1L, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)2L);
        page = TestCyclingGroupByHash.createPage(2);
        groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 1L, 0L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)2L);
    }

    @Test
    public void testPartialGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(3);
        Page page = TestCyclingGroupByHash.createPage(2);
        GroupByIdBlock groupByIdBlock = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIdBlock, 0L, 1L);
        Assert.assertEquals((long)groupByIdBlock.getGroupCount(), (long)2L);
    }

    private static void assertGrouping(GroupByIdBlock groupByIdBlock, long ... groupIds) {
        Assert.assertEquals((int)groupByIdBlock.getPositionCount(), (int)groupIds.length);
        for (int i = 0; i < groupByIdBlock.getPositionCount(); ++i) {
            Assert.assertEquals((long)groupByIdBlock.getGroupId(i), (long)groupIds[i]);
        }
    }

    private static GroupByIdBlock computeGroupByIdBlock(GroupByHash groupByHash, Page page) {
        Work groupIds = groupByHash.getGroupIds(page);
        while (!groupIds.process()) {
        }
        return (GroupByIdBlock)groupIds.getResult();
    }

    private static Page createPage(int positionCount) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        return new Page(new Block[]{block});
    }
}

