/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.SimplePagesHashStrategy;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimplePagesHashStrategy {
    @Test
    public void testHashRowWithIntegerType() {
        IntArrayBlock block = new IntArrayBlock(1, Optional.empty(), new int[]{1234});
        SimplePagesHashStrategy strategy = TestSimplePagesHashStrategy.createSimplePagesHashStrategy((Type)IntegerType.INTEGER, (List<Block>)ImmutableList.of((Object)block));
        Page page = new Page(new Block[]{block});
        Assert.assertEquals((long)strategy.hashRow(0, page), (long)-4467490526933615037L);
    }

    @Test
    public void testHashRowWithMapType() {
        MapType mapType = new MapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, new TypeOperators());
        Block block = mapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, 1}, (Block)new IntArrayBlock(1, Optional.empty(), new int[]{1234}), (Block)new IntArrayBlock(1, Optional.empty(), new int[]{5678}));
        SimplePagesHashStrategy strategy = TestSimplePagesHashStrategy.createSimplePagesHashStrategy((Type)mapType, (List<Block>)ImmutableList.of((Object)block));
        Page page = new Page(new Block[]{block});
        Assert.assertEquals((long)strategy.hashRow(0, page), (long)451258269207618863L);
    }

    @Test
    public void testRowEqualsRowWithIntegerType() {
        SimplePagesHashStrategy strategy = TestSimplePagesHashStrategy.createSimplePagesHashStrategy((Type)IntegerType.INTEGER, (List<Block>)ImmutableList.of());
        Page leftPage = new Page(new Block[]{new IntArrayBlock(1, Optional.empty(), new int[]{1234})});
        Page rightPage1 = new Page(new Block[]{new IntArrayBlock(1, Optional.empty(), new int[]{1234})});
        Page rightPage2 = new Page(new Block[]{new IntArrayBlock(1, Optional.empty(), new int[]{5678})});
        Assert.assertTrue((boolean)strategy.rowEqualsRow(0, leftPage, 0, rightPage1));
        Assert.assertFalse((boolean)strategy.rowEqualsRow(0, leftPage, 0, rightPage2));
    }

    @Test
    public void testRowEqualsRowWithMapType() {
        MapType mapType = new MapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, new TypeOperators());
        SimplePagesHashStrategy strategy = TestSimplePagesHashStrategy.createSimplePagesHashStrategy((Type)mapType, (List<Block>)ImmutableList.of());
        Page leftPage = new Page(new Block[]{mapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, 1}, (Block)new IntArrayBlock(1, Optional.empty(), new int[]{1234}), (Block)new IntArrayBlock(1, Optional.empty(), new int[]{5678}))});
        Page rightPage1 = new Page(new Block[]{mapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, 1}, (Block)new IntArrayBlock(1, Optional.empty(), new int[]{1234}), (Block)new IntArrayBlock(1, Optional.empty(), new int[]{5678}))});
        Page rightPage2 = new Page(new Block[]{mapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, 1}, (Block)new IntArrayBlock(1, Optional.empty(), new int[]{1234}), (Block)new IntArrayBlock(1, Optional.empty(), new int[]{1234}))});
        Assert.assertTrue((boolean)strategy.rowEqualsRow(0, leftPage, 0, rightPage1));
        Assert.assertFalse((boolean)strategy.rowEqualsRow(0, leftPage, 0, rightPage2));
    }

    @Test
    public void testCompareSortChannelPositionsWithIntegerType() {
        IntArrayBlock block = new IntArrayBlock(3, Optional.empty(), new int[]{1234, 5678, 1234});
        SimplePagesHashStrategy strategy = TestSimplePagesHashStrategy.createSimplePagesHashStrategy((Type)IntegerType.INTEGER, (List<Block>)ImmutableList.of((Object)block));
        Assert.assertEquals((int)strategy.compareSortChannelPositions(0, 0, 0, 1), (int)-1);
        Assert.assertEquals((int)strategy.compareSortChannelPositions(0, 1, 0, 0), (int)1);
        Assert.assertEquals((int)strategy.compareSortChannelPositions(0, 0, 0, 2), (int)0);
    }

    @Test
    public void testCompareSortChannelPositionsWithMapType() {
        MapType mapType = new MapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, new TypeOperators());
        Block block = mapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, 1}, (Block)new IntArrayBlock(1, Optional.empty(), new int[]{1234}), (Block)new IntArrayBlock(1, Optional.empty(), new int[]{5678}));
        SimplePagesHashStrategy strategy = TestSimplePagesHashStrategy.createSimplePagesHashStrategy((Type)mapType, (List<Block>)ImmutableList.of((Object)block));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> strategy.compareSortChannelPositions(0, 0, 0, 0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("type is not orderable");
    }

    private static SimplePagesHashStrategy createSimplePagesHashStrategy(Type type, List<Block> channelBlocks) {
        return new SimplePagesHashStrategy((List)ImmutableList.of((Object)type), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new ObjectArrayList(channelBlocks)), (List)ImmutableList.of((Object)0), OptionalInt.empty(), Optional.of(0), new BlockTypeOperators());
    }
}

