/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorStats;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.spi.Page;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWorkProcessorOperatorAdapter {
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testMetrics() {
        DriverContext driverContext = TestingTaskContext.builder((Executor)MoreExecutors.directExecutor(), (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).build().addPipelineContext(0, true, true, false).addDriverContext();
        OperatorFactory factory = WorkProcessorOperatorAdapter.createAdapterOperatorFactory((WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory)new TestWorkProcessorOperatorFactory());
        Operator operator = factory.createOperator(driverContext);
        OperatorContext context = operator.getOperatorContext();
        operator.getOutput();
        Assertions.assertThat((boolean)operator.isFinished()).isFalse();
        ((MapAssert)Assertions.assertThat((Map)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getMetrics().getMetrics()).hasSize(5)).containsEntry((Object)"testOperatorMetric", (Object)new LongCount(1L));
        operator.getOutput();
        Assertions.assertThat((boolean)operator.isFinished()).isTrue();
        ((MapAssert)Assertions.assertThat((Map)((OperatorStats)Iterables.getOnlyElement((Iterable)context.getNestedOperatorStats())).getMetrics().getMetrics()).hasSize(5)).containsEntry((Object)"testOperatorMetric", (Object)new LongCount(2L));
    }

    private static class TestWorkProcessorOperatorFactory
    implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory {
        private TestWorkProcessorOperatorFactory() {
        }

        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            throw new UnsupportedOperationException();
        }

        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext processorContext) {
            return new TestWorkProcessorOperator();
        }

        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory duplicate() {
            return new TestWorkProcessorOperatorFactory();
        }

        public int getOperatorId() {
            return 0;
        }

        public PlanNodeId getPlanNodeId() {
            return new PlanNodeId("test");
        }

        public String getOperatorType() {
            return "test";
        }
    }

    private static class TestWorkProcessorOperator
    implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
        private long count;

        private TestWorkProcessorOperator() {
        }

        public Metrics getMetrics() {
            return new Metrics((Map)ImmutableMap.of((Object)"testOperatorMetric", (Object)new LongCount(this.count)));
        }

        public WorkProcessor<Page> getOutputPages() {
            return WorkProcessor.of((Object[])new Page[]{new Page(0)}).withProcessEntryMonitor(() -> ++this.count);
        }

        public boolean needsInput() {
            return false;
        }

        public void addInput(Page page) {
            throw new UnsupportedOperationException();
        }

        public void finish() {
        }
    }
}

