/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.TypedSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.BlockTypeOperators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedSet {
    private static final BlockTypeOperators BLOCK_TYPE_OPERATORS = new BlockTypeOperators(new TypeOperators());
    private static final String FUNCTION_NAME = "typed_set_test";

    @Test
    public void testConstructor() {
        int i = -2;
        while (i <= -1) {
            int expectedSize = i++;
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTypedSet.createEqualityTypedSet((Type)BigintType.BIGINT, expectedSize)).isInstanceOf(IllegalArgumentException.class)).hasMessage("expectedSize must not be negative");
        }
        Assertions.assertThatThrownBy(() -> TypedSet.createEqualityTypedSet(null, null, null, (int)1, (String)FUNCTION_NAME)).isInstanceOfAny(new Class[]{NullPointerException.class, IllegalArgumentException.class});
    }

    @Test
    public void testGetElementPosition() {
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        TypedSet typedSet = TestTypedSet.createEqualityTypedSet((Type)BigintType.BIGINT, initialTypedSetEntryCount);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            typedSet.add((Block)blockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)elementCount);
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)j);
        }
    }

    @Test
    public void testGetElementPositionWithNull() {
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        TypedSet typedSet = TestTypedSet.createEqualityTypedSet((Type)BigintType.BIGINT, initialTypedSetEntryCount);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                blockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            }
            typedSet.add((Block)blockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)(elementCount - elementCount / 10 + 1));
        int nullCount = 0;
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            if (!blockBuilder.isNull(j)) {
                Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)(j - nullCount + 1));
                continue;
            }
            Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)0);
            ++nullCount;
        }
    }

    @Test
    public void testGetElementPositionWithProvidedEmptyBlockBuilder() {
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        BlockBuilder emptyBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        TypedSet typedSet = TestTypedSet.createDistinctTypedSet((Type)BigintType.BIGINT, initialTypedSetEntryCount, emptyBlockBuilder);
        BlockBuilder externalBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                externalBlockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(externalBlockBuilder, (long)i);
            }
            typedSet.add((Block)externalBlockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)emptyBlockBuilder.getPositionCount());
        Assert.assertEquals((int)typedSet.size(), (int)(elementCount - elementCount / 10 + 1));
        for (int j = 0; j < typedSet.size(); ++j) {
            Assert.assertEquals((int)typedSet.positionOf((Block)emptyBlockBuilder, j), (int)j);
        }
    }

    @Test
    public void testGetElementPositionWithProvidedNonEmptyBlockBuilder() {
        int i;
        int elementCount = 100;
        int initialTypedSetEntryCount = 10;
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        BlockBuilder firstBlockBuilder = pageBuilder.getBlockBuilder(0);
        for (int i2 = 0; i2 < elementCount; ++i2) {
            BigintType.BIGINT.writeLong(firstBlockBuilder, (long)i2);
        }
        pageBuilder.declarePositions(elementCount);
        BlockBuilder secondBlockBuilder = pageBuilder.getBlockBuilder(0);
        TypedSet typedSet = TestTypedSet.createDistinctTypedSet((Type)BigintType.BIGINT, initialTypedSetEntryCount, secondBlockBuilder);
        BlockBuilder externalBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                externalBlockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(externalBlockBuilder, (long)i);
            }
            typedSet.add((Block)externalBlockBuilder, i);
        }
        Assert.assertEquals((int)typedSet.size(), (int)(secondBlockBuilder.getPositionCount() - elementCount));
        Assert.assertEquals((int)typedSet.size(), (int)(elementCount - elementCount / 10 + 1));
        for (i = 0; i < typedSet.size(); ++i) {
            int expectedPositionInSecondBlockBuilder = i + elementCount;
            Assert.assertEquals((int)typedSet.positionOf((Block)secondBlockBuilder, expectedPositionInSecondBlockBuilder), (int)expectedPositionInSecondBlockBuilder);
        }
    }

    @Test
    public void testGetElementPositionRandom() {
        TypedSet set = TestTypedSet.createEqualityTypedSet((Type)VarcharType.VARCHAR, 1);
        this.testGetElementPositionRandomFor(set);
        BlockBuilder emptyBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 3);
        TypedSet setWithPassedInBuilder = TestTypedSet.createDistinctTypedSet((Type)VarcharType.VARCHAR, 1, emptyBlockBuilder);
        this.testGetElementPositionRandomFor(setWithPassedInBuilder);
    }

    @Test
    public void testBigintSimpleTypedSet() {
        ImmutableList expectedSetSizes = ImmutableList.of((Object)1, (Object)10, (Object)100, (Object)1000);
        ImmutableList longBlocks = ImmutableList.of((Object)BlockAssertions.createEmptyLongsBlock(), (Object)BlockAssertions.createLongsBlock(1L), (Object)BlockAssertions.createLongsBlock(1L, 2L, 3L), (Object)BlockAssertions.createLongsBlock(1L, 2L, 3L, 1L, 2L, 3L), (Object)BlockAssertions.createLongsBlock(1L, null, 3L), (Object)BlockAssertions.createLongsBlock(null, null, null), (Object)BlockAssertions.createLongSequenceBlock(0, 100), (Object)BlockAssertions.createLongSequenceBlock(-100, 100), (Object)BlockAssertions.createLongsBlock(Collections.nCopies(1, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies(100, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies((Integer)expectedSetSizes.get(expectedSetSizes.size() - 1) * 2, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies((Integer)expectedSetSizes.get(expectedSetSizes.size() - 1) * 2, 0L)), (Object[])new Block[0]);
        Iterator iterator = expectedSetSizes.iterator();
        while (iterator.hasNext()) {
            int expectedSetSize = (Integer)iterator.next();
            for (Block block : longBlocks) {
                TestTypedSet.testBigint(block, expectedSetSize);
            }
        }
    }

    @Test
    public void testMemoryExceeded() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            TypedSet typedSet = TestTypedSet.createEqualityTypedSet((Type)BigintType.BIGINT, 10);
            int i = 0;
            while ((long)i <= TypedSet.MAX_FUNCTION_MEMORY.toBytes() + 1L) {
                Block block = BlockAssertions.createLongsBlock(Collections.nCopies(1, Long.valueOf(i)));
                typedSet.add(block, 0);
                ++i;
            }
        }).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT});
    }

    private void testGetElementPositionRandomFor(TypedSet set) {
        BlockBuilder keys = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"abc"));
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            set.add((Block)keys, i);
        }
        BlockBuilder values = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"abc"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"bad"));
        values.appendNull();
        Assert.assertEquals((int)set.positionOf((Block)values, 4), (int)-1);
        Assert.assertEquals((int)set.positionOf((Block)values, 2), (int)0);
        Assert.assertEquals((int)set.positionOf((Block)values, 1), (int)2);
        Assert.assertEquals((int)set.positionOf((Block)values, 0), (int)1);
        Assert.assertFalse((boolean)set.contains((Block)values, 3));
        set.add((Block)values, 4);
        Assert.assertTrue((boolean)set.contains((Block)values, 4));
    }

    private static void testBigint(Block longBlock, int expectedSetSize) {
        TypedSet typedSet = TestTypedSet.createEqualityTypedSet((Type)BigintType.BIGINT, expectedSetSize);
        TestTypedSet.testBigintFor(typedSet, longBlock);
        BlockBuilder emptyBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, expectedSetSize);
        TypedSet typedSetWithPassedInBuilder = TestTypedSet.createDistinctTypedSet((Type)BigintType.BIGINT, expectedSetSize, emptyBlockBuilder);
        TestTypedSet.testBigintFor(typedSetWithPassedInBuilder, longBlock);
    }

    private static TypedSet createEqualityTypedSet(Type type, int expectedSize) {
        return TypedSet.createEqualityTypedSet((Type)type, (BlockTypeOperators.BlockPositionEqual)BLOCK_TYPE_OPERATORS.getEqualOperator(type), (BlockTypeOperators.BlockPositionHashCode)BLOCK_TYPE_OPERATORS.getHashCodeOperator(type), (int)expectedSize, (String)FUNCTION_NAME);
    }

    private static TypedSet createDistinctTypedSet(Type type, int expectedSize, BlockBuilder blockBuilder) {
        return TypedSet.createDistinctTypedSet((Type)type, (BlockTypeOperators.BlockPositionIsDistinctFrom)BLOCK_TYPE_OPERATORS.getDistinctFromOperator(type), (BlockTypeOperators.BlockPositionHashCode)BLOCK_TYPE_OPERATORS.getHashCodeOperator(type), (BlockBuilder)blockBuilder, (int)expectedSize, (String)FUNCTION_NAME);
    }

    private static void testBigintFor(TypedSet typedSet, Block longBlock) {
        HashSet<Long> set = new HashSet<Long>();
        for (int blockPosition = 0; blockPosition < longBlock.getPositionCount(); ++blockPosition) {
            long number = BigintType.BIGINT.getLong(longBlock, blockPosition);
            Assert.assertEquals((boolean)typedSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)typedSet.size(), (int)set.size());
            set.add(number);
            typedSet.add(longBlock, blockPosition);
            Assert.assertEquals((boolean)typedSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)typedSet.size(), (int)set.size());
        }
    }
}

