/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.groupby;

import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.function.BiConsumer;
import org.testng.Assert;

public class AggregationTestOutput {
    private final Object expectedValue;

    public AggregationTestOutput(Object expectedValue) {
        this.expectedValue = expectedValue;
    }

    public void validateAggregator(Type finalType, GroupedAggregator groupedAggregator, long groupId) {
        AggregationTestOutput.createEqualAssertion(this.expectedValue, groupId).accept(AggregationTestOutput.getGroupValue(finalType, groupedAggregator, (int)groupId), this.expectedValue);
    }

    private static BiConsumer<Object, Object> createEqualAssertion(Object expectedValue, long groupId) {
        BiConsumer<Object, Object> equalAssertion = (actual, expected) -> Assert.assertEquals((Object)actual, (Object)expected, (String)String.format("failure on group %s", groupId));
        if (expectedValue instanceof Double && !expectedValue.equals(Double.NaN)) {
            equalAssertion = (actual, expected) -> Assert.assertEquals((double)((Double)actual), (double)((Double)expected), (double)1.0E-10);
        }
        if (expectedValue instanceof Float && !expectedValue.equals(Float.valueOf(Float.NaN))) {
            equalAssertion = (actual, expected) -> Assert.assertEquals((float)((Float)actual).floatValue(), (float)((Float)expected).floatValue(), (float)1.0E-10f);
        }
        return equalAssertion;
    }

    private static Object getGroupValue(Type finalType, GroupedAggregator groupedAggregator, int groupId) {
        BlockBuilder out = finalType.createBlockBuilder(null, 1);
        groupedAggregator.evaluate(groupId, out);
        return BlockAssertions.getOnlyValue(finalType, out.build());
    }
}

