/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.testng.annotations.Test;

public class TestLongMaxNAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createLongSequenceBlock(start, start + length), BlockAssertions.createLongRepeatBlock(2, length)};
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return ImmutableList.of((Object)start);
        }
        return ImmutableList.of((Object)((long)start + (long)length - 1L), (Object)((long)start + (long)length - 2L));
    }

    @Test
    public void testMoreCornerCases() {
        this.testCustomAggregation(new Long[]{1L, 2L, null, 3L}, 5);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 0);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, -1);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 10001);
    }

    private void testInvalidAggregation(Long[] x, int n) {
        this.assertInvalidAggregation(() -> this.testAggregation(new long[0], BlockAssertions.createLongsBlock(x), BlockAssertions.createLongRepeatBlock(n, x.length)));
    }

    private void testCustomAggregation(Long[] values, int n) {
        PriorityQueue heap = new PriorityQueue(n);
        Arrays.stream(values).filter(Objects::nonNull).forEach(heap::add);
        Long[] expected = new Long[heap.size()];
        for (int i = heap.size() - 1; i >= 0; --i) {
            expected[i] = (Long)heap.remove();
        }
        this.testAggregation(Arrays.asList(expected), BlockAssertions.createLongsBlock(values), BlockAssertions.createLongRepeatBlock(n, values.length));
    }
}

