/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLongDecimalWithOverflowAndLongStateSerializer {
    private static final LongDecimalWithOverflowAndLongStateFactory STATE_FACTORY = new LongDecimalWithOverflowAndLongStateFactory();

    @Test(dataProvider="input")
    public void testSerde(long low, long high, long overflow, long count, int expectedLength) {
        LongDecimalWithOverflowAndLongState state = STATE_FACTORY.createSingleState();
        state.getDecimalArray()[0] = high;
        state.getDecimalArray()[1] = low;
        state.setOverflow(overflow);
        state.setLong(count);
        LongDecimalWithOverflowAndLongState outState = this.roundTrip(state, expectedLength);
        Assert.assertEquals((long)outState.getDecimalArray()[0], (long)high);
        Assert.assertEquals((long)outState.getDecimalArray()[1], (long)low);
        Assert.assertEquals((long)outState.getOverflow(), (long)overflow);
        Assert.assertEquals((long)outState.getLong(), (long)count);
    }

    @Test
    public void testNullSerde() {
        LongDecimalWithOverflowAndLongState state = STATE_FACTORY.createSingleState();
        LongDecimalWithOverflowAndLongState outState = this.roundTrip(state, 0);
        Assert.assertEquals((long)outState.getLong(), (long)0L);
    }

    private LongDecimalWithOverflowAndLongState roundTrip(LongDecimalWithOverflowAndLongState state, int expectedLength) {
        LongDecimalWithOverflowAndLongStateSerializer serializer = new LongDecimalWithOverflowAndLongStateSerializer();
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 1, 0);
        serializer.serialize(state, (BlockBuilder)out);
        Block serialized = out.build();
        Assert.assertEquals((int)serialized.getSliceLength(0), (int)(expectedLength * 8));
        LongDecimalWithOverflowAndLongState outState = STATE_FACTORY.createSingleState();
        serializer.deserialize(serialized, 0, outState);
        return outState;
    }

    @DataProvider
    public Object[][] input() {
        return new Object[][]{{3, 0, 0, 1, 1}, {3, 5, 0, 1, 2}, {3, 5, 7, 1, 4}, {3, 0, 0, 2, 3}, {3, 5, 0, 2, 4}, {3, 5, 7, 2, 4}, {3, 0, 7, 1, 3}, {3, 0, 7, 2, 3}, {0, 0, 0, 1, 1}, {0, 5, 0, 1, 2}, {0, 5, 7, 1, 4}, {0, 0, 0, 2, 3}, {0, 5, 0, 2, 4}, {0, 5, 7, 2, 4}, {0, 0, 7, 1, 3}, {0, 0, 7, 2, 3}};
    }
}

