/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import io.trino.RowPagesBuilder;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.FunctionManager;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.PageAssertions;
import io.trino.operator.index.DynamicTupleFilterFactory;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.testng.annotations.Test;

public class TestTupleFilterProcessor {
    @Test
    public void testFilter() {
        Page tuplePage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(1L, "a", 0.1).build());
        ImmutableList outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        Page inputPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("b", 1L, true, 0.1, 2.0).row("a", 1L, false, 0.1, 2.0).row("a", 0L, false, 0.2, 0.2).build());
        FunctionManager functionManager = FunctionManager.createTestingFunctionManager();
        DynamicTupleFilterFactory filterFactory = new DynamicTupleFilterFactory(42, new PlanNodeId("42"), new int[]{0, 1, 2}, new int[]{1, 0, 3}, (List)outputTypes, new PageFunctionCompiler(functionManager, 0), new BlockTypeOperators(new TypeOperators()));
        PageProcessor tupleFilterProcessor = (PageProcessor)filterFactory.createPageProcessor(tuplePage, OptionalInt.of(8192)).get();
        Page actualPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)tupleFilterProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), inputPage))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Page expectedPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("a", 1L, false, 0.1, 2.0).build());
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, actualPage, expectedPage);
    }
}

