/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.collect.ImmutableList;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.unspilled.JoinProbe;
import io.trino.operator.join.unspilled.LookupJoinPageBuilder;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.OptionalInt;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLookupJoinPageBuilder {
    @Test
    public void testPageBuilder() {
        int entries = 10000;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, entries);
        for (int i = 0; i < entries; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block, block});
        JoinProbe.JoinProbeFactory joinProbeFactory = new JoinProbe.JoinProbeFactory((List)ImmutableList.of((Object)0, (Object)1), (List)ImmutableList.of((Object)0, (Object)1), OptionalInt.empty());
        TestLookupSource lookupSource = new TestLookupSource((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), page);
        JoinProbe probe = joinProbeFactory.createJoinProbe(page, (LookupSource)lookupSource);
        LookupJoinPageBuilder lookupJoinPageBuilder = new LookupJoinPageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        int joinPosition = 0;
        while (!lookupJoinPageBuilder.isFull() && probe.advanceNextPosition()) {
            lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition++);
            lookupJoinPageBuilder.appendNullForBuild(probe);
        }
        Assert.assertFalse((boolean)lookupJoinPageBuilder.isEmpty());
        Page output = lookupJoinPageBuilder.build(probe);
        Assert.assertEquals((int)output.getChannelCount(), (int)4);
        Assert.assertTrue((boolean)(output.getBlock(0) instanceof DictionaryBlock));
        Assert.assertTrue((boolean)(output.getBlock(1) instanceof DictionaryBlock));
        for (int i = 0; i < output.getPositionCount(); ++i) {
            Assert.assertFalse((boolean)output.getBlock(0).isNull(i));
            Assert.assertFalse((boolean)output.getBlock(1).isNull(i));
            Assert.assertEquals((long)output.getBlock(0).getLong(i, 0), (long)(i / 2));
            Assert.assertEquals((long)output.getBlock(1).getLong(i, 0), (long)(i / 2));
            if (i % 2 == 0) {
                Assert.assertFalse((boolean)output.getBlock(2).isNull(i));
                Assert.assertFalse((boolean)output.getBlock(3).isNull(i));
                Assert.assertEquals((long)output.getBlock(2).getLong(i, 0), (long)(i / 2));
                Assert.assertEquals((long)output.getBlock(3).getLong(i, 0), (long)(i / 2));
                continue;
            }
            Assert.assertTrue((boolean)output.getBlock(2).isNull(i));
            Assert.assertTrue((boolean)output.getBlock(3).isNull(i));
        }
        Assert.assertTrue((boolean)lookupJoinPageBuilder.toString().contains("positionCount=" + output.getPositionCount()));
        lookupJoinPageBuilder.reset();
        Assert.assertTrue((boolean)lookupJoinPageBuilder.isEmpty());
    }

    @Test
    public void testDifferentPositions() {
        int i;
        int entries = 100;
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(entries);
        for (int i2 = 0; i2 < entries; ++i2) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i2);
        }
        Block block = blockBuilder.build();
        Page page = new Page(new Block[]{block});
        JoinProbe.JoinProbeFactory joinProbeFactory = new JoinProbe.JoinProbeFactory((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)0), OptionalInt.empty());
        TestLookupSource lookupSource = new TestLookupSource((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), page);
        LookupJoinPageBuilder lookupJoinPageBuilder = new LookupJoinPageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        JoinProbe probe = joinProbeFactory.createJoinProbe(page, (LookupSource)lookupSource);
        Page output = lookupJoinPageBuilder.build(probe);
        Assert.assertEquals((int)output.getChannelCount(), (int)2);
        Assert.assertTrue((boolean)(output.getBlock(0) instanceof DictionaryBlock));
        Assert.assertEquals((int)output.getPositionCount(), (int)0);
        lookupJoinPageBuilder.reset();
        probe = joinProbeFactory.createJoinProbe(page, (LookupSource)lookupSource);
        int joinPosition = 0;
        while (probe.advanceNextPosition()) {
            if (joinPosition % 2 != 1) {
                lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition);
            }
            ++joinPosition;
        }
        output = lookupJoinPageBuilder.build(probe);
        Assert.assertEquals((int)output.getChannelCount(), (int)2);
        Assert.assertTrue((boolean)(output.getBlock(0) instanceof DictionaryBlock));
        Assert.assertEquals((int)output.getPositionCount(), (int)(entries / 2));
        for (i = 0; i < entries / 2; ++i) {
            Assert.assertEquals((long)output.getBlock(0).getLong(i, 0), (long)(i * 2));
            Assert.assertEquals((long)output.getBlock(1).getLong(i, 0), (long)(i * 2));
        }
        lookupJoinPageBuilder.reset();
        probe = joinProbeFactory.createJoinProbe(page, (LookupSource)lookupSource);
        joinPosition = 0;
        while (probe.advanceNextPosition()) {
            lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition);
            ++joinPosition;
        }
        output = lookupJoinPageBuilder.build(probe);
        Assert.assertEquals((int)output.getChannelCount(), (int)2);
        Assert.assertFalse((boolean)(output.getBlock(0) instanceof DictionaryBlock));
        Assert.assertEquals((int)output.getPositionCount(), (int)entries);
        for (i = 0; i < entries; ++i) {
            Assert.assertEquals((long)output.getBlock(0).getLong(i, 0), (long)i);
            Assert.assertEquals((long)output.getBlock(1).getLong(i, 0), (long)i);
        }
        lookupJoinPageBuilder.reset();
        probe = joinProbeFactory.createJoinProbe(page, (LookupSource)lookupSource);
        joinPosition = 0;
        while (probe.advanceNextPosition()) {
            if (joinPosition >= 10 && joinPosition < 50) {
                lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, (long)joinPosition);
            }
            ++joinPosition;
        }
        output = lookupJoinPageBuilder.build(probe);
        Assert.assertEquals((int)output.getChannelCount(), (int)2);
        Assert.assertFalse((boolean)(output.getBlock(0) instanceof DictionaryBlock));
        Assert.assertEquals((int)output.getPositionCount(), (int)40);
        for (i = 10; i < 50; ++i) {
            Assert.assertEquals((long)output.getBlock(0).getLong(i - 10, 0), (long)i);
            Assert.assertEquals((long)output.getBlock(1).getLong(i - 10, 0), (long)i);
        }
    }

    @Test
    public void testCrossJoinWithEmptyBuild() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(blockBuilder, 0L);
        Page page = new Page(new Block[]{blockBuilder.build()});
        TestLookupSource lookupSource = new TestLookupSource((List<Type>)ImmutableList.of(), page);
        JoinProbe probe = new JoinProbe.JoinProbeFactory((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)0), OptionalInt.empty()).createJoinProbe(page, (LookupSource)lookupSource);
        LookupJoinPageBuilder lookupJoinPageBuilder = new LookupJoinPageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
        probe.advanceNextPosition();
        for (int i = 0; i < 300000; ++i) {
            lookupJoinPageBuilder.appendRow(probe, (LookupSource)lookupSource, 0L);
        }
        Assert.assertTrue((boolean)lookupJoinPageBuilder.isFull());
    }

    private static final class TestLookupSource
    implements LookupSource {
        private final List<Type> types;
        private final Page page;

        public TestLookupSource(List<Type> types, Page page) {
            this.types = types;
            this.page = page;
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public long getJoinPositionCount() {
            throw new UnsupportedOperationException();
        }

        public long joinPositionWithinPartition(long joinPosition) {
            throw new UnsupportedOperationException();
        }

        public long getInMemorySizeInBytes() {
            throw new UnsupportedOperationException();
        }

        public long getJoinPosition(int position, Page page, Page allChannelsPage, long rawHash) {
            throw new UnsupportedOperationException();
        }

        public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
            return -1L;
        }

        public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            throw new UnsupportedOperationException();
        }

        public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            throw new UnsupportedOperationException();
        }

        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            for (int i = 0; i < this.types.size(); ++i) {
                this.types.get(i).appendTo(this.page.getBlock(i), (int)position, pageBuilder.getBlockBuilder(i));
            }
        }

        public void close() {
        }
    }
}

