/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.block.BlockAssertions;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.operator.project.PageFieldsToInputParametersRewriter;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestPageFieldsToInputParametersRewriter {
    private static final TypeAnalyzer TYPE_ANALYZER = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setTransactionId(TransactionId.create()).build();

    @Test
    public void testEagerLoading() {
        RowExpressionBuilder builder = RowExpressionBuilder.create().addSymbol("bigint0", (Type)BigintType.BIGINT).addSymbol("bigint1", (Type)BigintType.BIGINT);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 + 5"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("CAST((bigint0 * 10) AS INT)"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("COALESCE((bigint0 % 2), bigint0)"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 IN (1, 2, 3)"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 > 0"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 + 1 = 0"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 BETWEEN 1 AND 10"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("CASE WHEN (bigint0 > 0) THEN bigint0 ELSE null END"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("CASE bigint0 WHEN 1 THEN 1 ELSE -bigint0 END"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("IF(bigint0 >= 150000, 0, 1)"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("IF(bigint0 >= 150000, bigint0, 0)"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("COALESCE(0, bigint0) + bigint0"), 1);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 + (2 * bigint1)"), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("NULLIF(bigint0, bigint1)"), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("COALESCE(CEIL(bigint0 / bigint1), 0)"), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("CASE WHEN (bigint0 > bigint1) THEN 1 ELSE 0 END"), 2);
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("CASE WHEN (bigint0 > 0) THEN bigint1 ELSE 0 END"), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("COALESCE(ROUND(bigint0), bigint1)"), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 > 0 AND bigint1 > 0"), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 > 0 OR bigint1 > 0"), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("bigint0 BETWEEN 0 AND bigint1"), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("IF(bigint1 >= 150000, 0, bigint0)"), 2, (Set<Integer>)ImmutableSet.of((Object)0));
        builder = RowExpressionBuilder.create().addSymbol("array_bigint0", (Type)new ArrayType((Type)BigintType.BIGINT)).addSymbol("array_bigint1", (Type)new ArrayType((Type)BigintType.BIGINT));
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("TRANSFORM(array_bigint0, x -> 1)"), 1, (Set<Integer>)ImmutableSet.of());
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("TRANSFORM(array_bigint0, x -> 2 * x)"), 1, (Set<Integer>)ImmutableSet.of());
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(builder.buildExpression("ZIP_WITH(array_bigint0, array_bigint1, (x, y) -> 2 * x)"), 2, (Set<Integer>)ImmutableSet.of());
    }

    private static void verifyEagerlyLoadedColumns(RowExpression rowExpression, int columnCount) {
        TestPageFieldsToInputParametersRewriter.verifyEagerlyLoadedColumns(rowExpression, columnCount, (Set)IntStream.range(0, columnCount).boxed().collect(ImmutableSet.toImmutableSet()));
    }

    private static void verifyEagerlyLoadedColumns(RowExpression rowExpression, int columnCount, Set<Integer> eagerlyLoadedChannels) {
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters((RowExpression)rowExpression);
        Block[] blocks = new Block[columnCount];
        for (int channel = 0; channel < columnCount; ++channel) {
            blocks[channel] = TestPageFieldsToInputParametersRewriter.lazyWrapper(BlockAssertions.createLongSequenceBlock(0, 100));
        }
        Page page = result.getInputChannels().getInputChannels(new Page(blocks));
        for (int channel = 0; channel < columnCount; ++channel) {
            Assertions.assertThat((boolean)page.getBlock(channel).isLoaded()).isEqualTo(eagerlyLoadedChannels.contains(channel));
        }
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }

    private static class RowExpressionBuilder {
        private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
        private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
        private final List<Type> types = new LinkedList<Type>();

        private RowExpressionBuilder() {
        }

        private static RowExpressionBuilder create() {
            return new RowExpressionBuilder();
        }

        private RowExpressionBuilder addSymbol(String name, Type type) {
            Symbol symbol = new Symbol(name);
            this.symbolTypes.put(symbol, type);
            this.sourceLayout.put(symbol, this.types.size());
            this.types.add(type);
            return this;
        }

        private RowExpression buildExpression(String value) {
            Expression expression = ExpressionTestUtils.createExpression(value, TestingPlannerContext.PLANNER_CONTEXT, TypeProvider.copyOf(this.symbolTypes));
            return SqlToRowExpressionTranslator.translate((Expression)expression, (Map)TYPE_ANALYZER.getTypes(TEST_SESSION, TypeProvider.copyOf(this.symbolTypes), expression), this.sourceLayout, (Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (FunctionManager)TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), (Session)TEST_SESSION, (boolean)true);
        }
    }
}

