/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.trino.FullConnectorSession;
import io.trino.jmh.Benchmarks;
import io.trino.json.ir.IrArithmeticBinary;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrPathNode;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingSession;
import io.trino.type.Json2016Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkJsonPathBinaryOperators {
    private static final int POSITION_COUNT = 100000;
    private static final FullConnectorSession FULL_CONNECTOR_SESSION = new FullConnectorSession(TestingSession.testSessionBuilder().build(), ConnectorIdentity.ofUser((String)"test"));

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonValueFunctionConstantTypes(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonValuePageProcessor().process((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPageConstantTypes()));
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonValueFunctionVaryingTypes(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonValuePageProcessor().process((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPageVaryingTypes()));
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonValueFunctionMultipleVaryingTypes(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonValuePageProcessor().process((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPageMultipleVaryingTypes()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkJsonPathBinaryOperators().benchmarkJsonValueFunctionConstantTypes(data);
        new BenchmarkJsonPathBinaryOperators().benchmarkJsonValueFunctionVaryingTypes(data);
        new BenchmarkJsonPathBinaryOperators().benchmarkJsonValueFunctionMultipleVaryingTypes(data);
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkJsonPathBinaryOperators.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Page pageConstantTypes;
        private Page pageVaryingTypes;
        private Page pageMultipleVaryingTypes;
        private PageProcessor jsonValuePageProcessor;

        @Setup
        public void setup() {
            this.pageConstantTypes = new Page(new Block[]{BenchmarkData.createChannelConstantTypes(100000)});
            this.pageVaryingTypes = new Page(new Block[]{BenchmarkData.createChannelVaryingTypes(100000)});
            this.pageMultipleVaryingTypes = new Page(new Block[]{BenchmarkData.createChannelMultipleVaryingTypes(100000)});
            this.jsonValuePageProcessor = BenchmarkData.createJsonValuePageProcessor();
        }

        private static PageProcessor createJsonValuePageProcessor() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            Type jsonPath2016Type = TestingPlannerContext.PLANNER_CONTEXT.getTypeManager().getType(TypeId.of((String)"JsonPath2016"));
            IrArithmeticBinary path = new IrArithmeticBinary(IrArithmeticBinary.Operator.ADD, (IrPathNode)new IrMemberAccessor((IrPathNode)new IrContextVariable(Optional.empty()), Optional.of("first"), Optional.empty()), (IrPathNode)new IrMemberAccessor((IrPathNode)new IrContextVariable(Optional.empty()), Optional.of("second"), Optional.empty()), Optional.empty());
            ImmutableList jsonValueProjection = ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"$json_value"), TypeSignatureProvider.fromTypes((List)ImmutableList.of((Object)Json2016Type.JSON_2016, (Object)jsonPath2016Type, (Object)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, (Object)TinyintType.TINYINT, (Object)VarcharType.VARCHAR, (Object)TinyintType.TINYINT, (Object)VarcharType.VARCHAR))), (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"$varchar_to_json"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN})), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN))), (Object)Expressions.constant((Object)new IrJsonPath(false, (IrPathNode)path), (Type)jsonPath2016Type), (Object)Expressions.constantNull((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT), (Object)Expressions.constantNull((Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT), (Object)Expressions.constantNull((Type)VarcharType.VARCHAR))));
            return (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)jsonValueProjection).get();
        }

        private static Block createChannelConstantTypes(int positionCount) {
            BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                DynamicSliceOutput slice = new DynamicSliceOutput(20);
                slice.appendBytes("{\"first\" : ".getBytes(StandardCharsets.UTF_8)).appendBytes(String.format("%e", (double)position % 100.0).getBytes(StandardCharsets.UTF_8)).appendBytes(", \"second\" : ".getBytes(StandardCharsets.UTF_8)).appendBytes(String.format("%s", position % 10).getBytes(StandardCharsets.UTF_8)).appendByte(125);
                VarcharType.VARCHAR.writeSlice(blockBuilder, slice.slice());
            }
            return blockBuilder.build();
        }

        private static Block createChannelVaryingTypes(int positionCount) {
            BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                DynamicSliceOutput slice = new DynamicSliceOutput(20);
                slice.appendBytes("{\"first\" : ".getBytes(StandardCharsets.UTF_8));
                if (position % 3 == 0) {
                    slice.appendBytes(String.format("%e", (double)position % 100.0).getBytes(StandardCharsets.UTF_8));
                } else if (position % 3 == 1) {
                    slice.appendBytes(String.format("%s", (long)(position % 100) * 1000000000000L).getBytes(StandardCharsets.UTF_8));
                } else {
                    slice.appendBytes(String.format("%s", position % 100).getBytes(StandardCharsets.UTF_8));
                }
                slice.appendBytes(", \"second\" : ".getBytes(StandardCharsets.UTF_8)).appendBytes(String.format("%s", position % 10).getBytes(StandardCharsets.UTF_8)).appendByte(125);
                VarcharType.VARCHAR.writeSlice(blockBuilder, slice.slice());
            }
            return blockBuilder.build();
        }

        private static Block createChannelMultipleVaryingTypes(int positionCount) {
            BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                DynamicSliceOutput slice = new DynamicSliceOutput(20);
                slice.appendBytes("{\"first\" : ".getBytes(StandardCharsets.UTF_8));
                if (position % 3 == 0) {
                    slice.appendBytes(String.format("%e", (double)position % 100.0).getBytes(StandardCharsets.UTF_8));
                } else if (position % 3 == 1) {
                    slice.appendBytes(String.format("%s", (long)(position % 100) * 1000000000000L).getBytes(StandardCharsets.UTF_8));
                } else {
                    slice.appendBytes(String.format("%s", position % 100).getBytes(StandardCharsets.UTF_8));
                }
                slice.appendBytes(", \"second\" : ".getBytes(StandardCharsets.UTF_8));
                if (position % 4 == 0) {
                    slice.appendBytes(String.format("%e", (double)position % 10.0).getBytes(StandardCharsets.UTF_8));
                } else if (position % 4 == 1) {
                    slice.appendBytes(Decimals.toString((long)(position % 10), (int)2).getBytes(StandardCharsets.UTF_8));
                } else if (position % 4 == 2) {
                    slice.appendBytes(String.format("%s", (long)(position % 10) * 1000000000000L).getBytes(StandardCharsets.UTF_8));
                } else {
                    slice.appendBytes(String.format("%s", position % 10).getBytes(StandardCharsets.UTF_8));
                }
                slice.appendByte(125);
                VarcharType.VARCHAR.writeSlice(blockBuilder, slice.slice());
            }
            return blockBuilder.build();
        }

        public PageProcessor getJsonValuePageProcessor() {
            return this.jsonValuePageProcessor;
        }

        public Page getPageConstantTypes() {
            return this.pageConstantTypes;
        }

        public Page getPageVaryingTypes() {
            return this.pageVaryingTypes;
        }

        public Page getPageMultipleVaryingTypes() {
            return this.pageMultipleVaryingTypes;
        }
    }
}

