/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.operator.scalar.TypeOperatorBenchmarkUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=30, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=15, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkRowHashCodeOperator {
    private static final int POSITIONS = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public long hashOperator(BenchmarkData data) throws Throwable {
        return data.getHashBlock().invokeExact(data.getBlock());
    }

    @Test
    public void test() throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.hashOperator(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkRowHashCodeOperator.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "VARCHAR"})
        private String type = "BIGINT";
        @Param(value={"1", "8", "16", "32", "64", "128"})
        private int fieldCount = 32;
        private MethodHandle hashBlock;
        private Block block;

        @Setup
        public void setup() {
            RowType rowType = RowType.anonymous((List)ImmutableList.copyOf(Collections.nCopies(this.fieldCount, TypeOperatorBenchmarkUtil.toType(this.type))));
            this.block = BenchmarkData.createChannel(10000, rowType);
            this.hashBlock = TypeOperatorBenchmarkUtil.getHashCodeBlockMethod((Type)rowType);
        }

        private static Block createChannel(int positionCount, RowType rowType) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            BlockBuilder blockBuilder = rowType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                List fields = rowType.getFields();
                for (RowType.Field field : fields) {
                    TypeOperatorBenchmarkUtil.addElement(field.getType(), random, entryBuilder);
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public MethodHandle getHashBlock() {
            return this.hashBlock;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

