/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.JsonType;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJsonFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testIsJsonScalar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "JSON 'null'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "JSON 'true'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "JSON '1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "JSON '\"str\"'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "'null'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "'true'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "'1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "'\"str\"'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "JSON '[1, 2, 3]'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "JSON '{\"a\": 1, \"b\": 2}'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "'[1, 2, 3]'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("is_json_scalar", "'{\"a\": 1, \"b\": 2}'")))).isEqualTo(false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("is_json_scalar", "''").evaluate()).hasMessage("Invalid JSON value: ");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("is_json_scalar", "'[1'").evaluate()).hasMessage("Invalid JSON value: [1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("is_json_scalar", "'1 trailing'").evaluate()).hasMessage("Invalid JSON value: 1 trailing");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("is_json_scalar", "'[1, 2] trailing'").evaluate()).hasMessage("Invalid JSON value: [1, 2] trailing");
    }

    @Test
    public void testJsonArrayLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "'[]'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "'[1]'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "'[1, \"foo\", null]'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "'[2, 4, {\"a\": [8, 9]}, [], [5], 4]'")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "JSON '[]'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "JSON '[1]'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "JSON '[1, \"foo\", null]'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "JSON '[2, 4, {\"a\": [8, 9]}, [], [5], 4]'")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "null")))).isNull((Type)BigintType.BIGINT);
    }

    @Test
    public void testJsonArrayContainsBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[true]'", "true")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[false]'", "false")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[true, false]'", "false")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[false, true]'", "true")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[[true]]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, \"foo\", null, \"true\"]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[2, 4, {\"a\": [8, 9]}, [], [5], false]'", "false")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[true]'", "true")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[false]'", "false")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[true, false]'", "false")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[false, true]'", "true")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[[true]]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1, \"foo\", null, \"true\"]'", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[2, 4, {\"a\": [8, 9]}, [], [5], false]'", "false")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "true")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[]'", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testJsonArrayContainsLong() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[]'", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[3]'", "3")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[-4]'", "-4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1.0]'", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[[2]]'", "2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, \"foo\", null, \"8\"]'", "8")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[2, 4, {\"a\": [8, 9]}, [], [5], 6]'", "6")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[92233720368547758071]'", "-9")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[]'", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[3]'", "3")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[-4]'", "-4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1.0]'", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[[2]]'", "2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1, \"foo\", null, \"8\"]'", "8")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[2, 4, {\"a\": [8, 9]}, [], [5], 6]'", "6")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[92233720368547758071]'", "-9")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "1")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[3]'", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testJsonArrayContainsDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[]'", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1.5]'", "1.5")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[-9.5]'", "-9.5")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1]'", "1.0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[[2.5]]'", "2.5")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, \"foo\", null, \"8.2\"]'", "8.2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[2, 4, {\"a\": [8, 9]}, [], [5], 6.1]'", "6.1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[9.6E400]'", "4.2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[]'", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1.5]'", "1.5")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[-9.5]'", "-9.5")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1]'", "1.0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[[2.5]]'", "2.5")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1, \"foo\", null, \"8.2\"]'", "8.2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[2, 4, {\"a\": [8, 9]}, [], [5], 6.1]'", "6.1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[9.6E400]'", "4.2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "1.5")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[3.5]'", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testJsonArrayContainsString() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[]'", "'x'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[\"foo\"]'", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[\"foo\", null]'", "cast(null as varchar)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[\"8\"]'", "'8'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, \"foo\", null]'", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, 5]'", "'5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[2, 4, {\"a\": [8, 9]}, [], [5], \"6\"]'", "'6'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[]'", "'x'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[\"foo\"]'", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[\"foo\", null]'", "cast(null as varchar)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[\"8\"]'", "'8'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1, \"foo\", null]'", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[1, 5]'", "'5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "JSON '[2, 4, {\"a\": [8, 9]}, [], [5], \"6\"]'", "'6'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "'x'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "''")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "null", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[\"\"]'", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[\"\"]'", "''")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[\"\"]'", "'x'")))).isEqualTo(false);
    }

    @Test
    public void testJsonArrayGetLong() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[2, 7, 4]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("7");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[2, 7, 4, 6, 8, 1, 0]'", "6")))).hasType((Type)JsonType.JSON).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[]'", "0")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1, 3, 2]'", "3")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[2, 7, 4, 6, 8, 1, 0]'", "-1")))).hasType((Type)JsonType.JSON).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[2, 7, 4, 6, 8, 1, 0]'", "-2")))).hasType((Type)JsonType.JSON).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[2, 7, 4, 6, 8, 1, 0]'", "-7")))).hasType((Type)JsonType.JSON).isEqualTo("2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[2, 7, 4, 6, 8, 1, 0]'", "-8")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[1]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[2, 7, 4]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("7");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[2, 7, 4, 6, 8, 1, 0]'", "6")))).hasType((Type)JsonType.JSON).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[]'", "0")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[1, 3, 2]'", "3")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[2, 7, 4, 6, 8, 1, 0]'", "-1")))).hasType((Type)JsonType.JSON).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[2, 7, 4, 6, 8, 1, 0]'", "-2")))).hasType((Type)JsonType.JSON).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[2, 7, 4, 6, 8, 1, 0]'", "-7")))).hasType((Type)JsonType.JSON).isEqualTo("2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[2, 7, 4, 6, 8, 1, 0]'", "-8")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[]'", "null")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1]'", "null")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "''", "null")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "''", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "''", "-1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1]'", "-9223372036854775807 - 1")))).isNull((Type)JsonType.JSON);
    }

    @Test
    public void testJsonArrayGetString() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[\"jhfa\"]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("jhfa");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[\"jhfa\", null]'", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[\"as\", \"fgs\", \"tehgf\"]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("fgs");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[\"as\", \"fgs\", \"tehgf\", \"gjyj\", \"jut\"]'", "4")))).hasType((Type)JsonType.JSON).isEqualTo("jut");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[\"jhfa\"]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("jhfa");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[\"jhfa\", null]'", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[\"as\", \"fgs\", \"tehgf\"]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("fgs");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[\"as\", \"fgs\", \"tehgf\", \"gjyj\", \"jut\"]'", "4")))).hasType((Type)JsonType.JSON).isEqualTo("jut");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[\"\"]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[]'", "0")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[null]'", "0")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[]'", "null")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1]'", "-9223372036854775807 - 1")))).isNull((Type)JsonType.JSON);
    }

    @Test
    public void testJsonArrayGetDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[3.14]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("3.14");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[3.14, null]'", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1.12, 3.54, 2.89]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("3.54");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[0.58, 9.7, 7.6, 11.2, 5.02]'", "4")))).hasType((Type)JsonType.JSON).isEqualTo("5.02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[3.14]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("3.14");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[3.14, null]'", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[1.12, 3.54, 2.89]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("3.54");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[0.58, 9.7, 7.6, 11.2, 5.02]'", "4")))).hasType((Type)JsonType.JSON).isEqualTo("5.02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1.0]'", "-1")))).hasType((Type)JsonType.JSON).isEqualTo("1.0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[1.0]'", "null")))).isNull((Type)JsonType.JSON);
    }

    @Test
    public void testJsonArrayGetBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[true]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("true");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[true, null]'", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[false, false, true]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[true, false, false, true, true, false]'", "5")))).hasType((Type)JsonType.JSON).isEqualTo("false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[true]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("true");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[true, null]'", "1")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[false, false, true]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "JSON '[true, false, false, true, true, false]'", "5")))).hasType((Type)JsonType.JSON).isEqualTo("false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[true]'", "-1")))).hasType((Type)JsonType.JSON).isEqualTo("true");
    }

    @Test
    public void testJsonArrayGetNonScalar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"hello\":\"world\"}]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("{\"hello\":\"world\"}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"hello\":\"world\"}, [1,2,3]]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("[1,2,3]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"hello\":\"world\"}, [1,2, {\"x\" : 2} ]]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("[1,2,{\"x\":2}]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"hello\":\"world\"}, {\"a\":[{\"x\":99}]}]'", "1")))).hasType((Type)JsonType.JSON).isEqualTo("{\"a\":[{\"x\":99}]}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"hello\":\"world\"}, {\"a\":[{\"x\":99}]}]'", "-1")))).hasType((Type)JsonType.JSON).isEqualTo("{\"a\":[{\"x\":99}]}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"hello\": null}]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("{\"hello\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"\":\"\"}]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":\"\"}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{null:null}]'", "0")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{null:\"\"}]'", "0")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"\":null}]'", "0")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_get", "'[{\"\":null}]'", "-1")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":null}");
    }

    @Test
    public void testJsonArrayContainsInvalid() {
        for (String value : new String[]{"'x'", "2.5", "8", "true", "cast(null as varchar)"}) {
            for (String array : new String[]{"", "123", "[", "[1,0,]", "[1,,0]"}) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'%s'".formatted(array), value)))).isNull((Type)BooleanType.BOOLEAN);
            }
        }
    }

    @Test
    public void testInvalidJsonParse() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("JSON 'INVALID'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "'INVALID'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "'\"x\": 1'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "'{}{'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "'{} \"a\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "'{}{abc'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "'{}abc'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_parse", "''").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testJsonFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_format", "JSON '[\"a\", \"b\"]'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("[\"a\",\"b\"]");
    }

    @Test
    public void testJsonSize() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'{\"x\": {\"a\" : 1, \"b\" : 2} }'", "'$'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'{\"x\": {\"a\" : 1, \"b\" : 2} }'", "'$.x'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'{\"x\": {\"a\" : 1, \"b\" : [1,2,3], \"c\" : {\"w\":9}} }'", "'$.x'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'{\"x\": {\"a\" : 1, \"b\" : 2} }'", "'$.x.a'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'[1,2,3]'", "'$'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'[1,2,3]'", "CHAR '$'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "null", "'$'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'INVALID_JSON'", "'$'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "'[1,2,3]'", "null")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "JSON '{\"x\": {\"a\" : 1, \"b\" : 2} }'", "'$'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "JSON '{\"x\": {\"a\" : 1, \"b\" : 2} }'", "'$.x'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "JSON '{\"x\": {\"a\" : 1, \"b\" : [1,2,3], \"c\" : {\"w\":9}} }'", "'$.x'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "JSON '{\"x\": {\"a\" : 1, \"b\" : 2} }'", "'$.x.a'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "JSON '[1,2,3]'", "'$'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "null", "'%'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_size", "JSON '[1,2,3]'", "null")))).isNull((Type)BigintType.BIGINT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_size", "'{\"\":\"\"}'", "''").evaluate()).hasMessage("Invalid JSON path: ''");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_size", "'{\"\":\"\"}'", "CHAR ' '").evaluate()).hasMessage("Invalid JSON path: ' '");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_size", "'{\"\":\"\"}'", "'.'").evaluate()).hasMessage("Invalid JSON path: '.'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_size", "'{\"\":\"\"}'", "'null'").evaluate()).hasMessage("Invalid JSON path: 'null'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("json_size", "'{\"\":\"\"}'", "'null'").evaluate()).hasMessage("Invalid JSON path: 'null'");
    }
}

