/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestTypeOfFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimpleType() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(1 AS BIGINT)")))).isEqualTo("bigint");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(1 AS INTEGER)")))).isEqualTo("integer");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(1 AS VARCHAR)")))).isEqualTo("varchar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(1 AS DOUBLE)")))).isEqualTo("double");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "123")))).isEqualTo("integer");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "'cat'")))).isEqualTo("varchar(3)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "NULL")))).isEqualTo("unknown");
    }

    @Test
    public void testParametricType() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS VARCHAR(10))")))).isEqualTo("varchar(10)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS DECIMAL(5,1))")))).isEqualTo("decimal(5,1)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS DECIMAL(1))")))).isEqualTo("decimal(1,0)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS DECIMAL)")))).isEqualTo("decimal(38,0)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS ARRAY(INTEGER))")))).isEqualTo("array(integer)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS ARRAY(DECIMAL(5,1)))")))).isEqualTo("array(decimal(5,1))");
    }

    @Test
    public void testNestedType() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS ARRAY(ARRAY(ARRAY(INTEGER))))")))).isEqualTo("array(array(array(integer)))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CAST(NULL AS ARRAY(ARRAY(ARRAY(DECIMAL(5,1)))))")))).isEqualTo("array(array(array(decimal(5,1))))");
    }

    @Test
    public void testComplex() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CONCAT('ala','ma','kota')")))).isEqualTo("varchar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "CONCAT(CONCAT('ala','ma','kota'), 'baz')")))).isEqualTo("varchar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "ARRAY [CAST(1 AS INTEGER),CAST(2 AS INTEGER),CAST(3 AS INTEGER)]")))).isEqualTo("array(integer)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "sin(2)")))).isEqualTo("double");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("typeof", "2+sin(2)+2.3")))).isEqualTo("double");
    }

    @Test
    public void testLambda() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("typeof(x -> x)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (<function>) for function typeof. Expected: typeof(t) T");
    }
}

