/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestZipWithFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSameLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "ARRAY[]").binding("b", "ARRAY[]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)UnknownType.UNKNOWN, (Object)UnknownType.UNKNOWN)))).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY['a', 'b']")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)1), (Object)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)1), (Object)ImmutableList.of((Object)"b", (Object)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "ARRAY[1, 2]").binding("b", "ARRAY[VARCHAR 'a', VARCHAR 'b']")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)1), (Object)ImmutableList.of((Object)"b", (Object)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x + y)").binding("a", "ARRAY[1, 1]").binding("b", "ARRAY[1, 2]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x * y)").binding("a", "CAST(ARRAY[3, 5] AS ARRAY(BIGINT))").binding("b", "CAST(ARRAY[1, 2] AS ARRAY(BIGINT))")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)3L, (Object)10L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x OR y)").binding("a", "ARRAY[true, false]").binding("b", "ARRAY[false, true]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> concat(x, y))").binding("a", "ARRAY['a', 'b']").binding("b", "ARRAY['c', 'd']")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(ImmutableList.of((Object)"ac", (Object)"bd"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> map_concat(x, y))").binding("a", "ARRAY[MAP(ARRAY[CAST ('a' AS VARCHAR)], ARRAY[1]), MAP(ARRAY[VARCHAR 'b'], ARRAY[2])]").binding("b", "ARRAY[MAP(ARRAY['c'], ARRAY[3]), MAP()]")))).hasType((Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"c", (Object)3), (Object)ImmutableMap.of((Object)"b", (Object)2)));
    }

    @Test
    public void testDifferentLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "ARRAY[1]").binding("b", "ARRAY['a', 'bc']")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)2), (Object)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)1), Arrays.asList("bc", null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "ARRAY[NULL, 2]").binding("b", "ARRAY['a']")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)1), (Object)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of(Arrays.asList("a", null), Arrays.asList(null, 2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x + y)").binding("a", "ARRAY[NULL, NULL]").binding("b", "ARRAY[NULL, 2, 1]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(null, null, null));
    }

    @Test
    public void testWithNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "CAST(NULL AS ARRAY(UNKNOWN))").binding("b", "ARRAY[]")))).isNull((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)UnknownType.UNKNOWN, (Object)UnknownType.UNKNOWN))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> (y, x))").binding("a", "ARRAY[NULL]").binding("b", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)UnknownType.UNKNOWN, (Object)UnknownType.UNKNOWN)))).isEqualTo(ImmutableList.of(Arrays.asList(null, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x IS NULL AND y IS NULL)").binding("a", "ARRAY[NULL]").binding("b", "ARRAY[NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x IS NULL OR y IS NULL)").binding("a", "ARRAY['a', NULL]").binding("b", "ARRAY[NULL, 1]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> x + y)").binding("a", "ARRAY[1, NULL]").binding("b", "ARRAY[3, 4]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(4, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("zip_with(a, b, (x, y) -> NULL)").binding("a", "ARRAY['a', 'b']").binding("b", "ARRAY[1, 3]")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Arrays.asList(null, null));
    }
}

