/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public abstract class BaseStrictSymbolsMatcher
implements Matcher {
    private final Function<PlanNode, Set<Symbol>> getActual;

    public BaseStrictSymbolsMatcher(Function<PlanNode, Set<Symbol>> getActual) {
        this.getActual = Objects.requireNonNull(getActual, "getActual is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        try {
            Set<Symbol> ignored = this.getActual.apply(node);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        return new MatchResult(this.getActual.apply(node).equals(this.getExpectedSymbols(node, session, metadata, symbolAliases)));
    }

    protected abstract Set<Symbol> getExpectedSymbols(PlanNode var1, Session var2, Metadata var3, SymbolAliases var4);
}

