/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowSpecification;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class FunctionCallProvider
implements ExpectedValueProvider<FunctionCall> {
    private final boolean isWindowFunction;
    private final QualifiedName name;
    private final Optional<WindowFrame> frame;
    private final boolean distinct;
    private final List<PlanTestSymbol> args;
    private final List<PlanMatchPattern.Ordering> orderBy;
    private final Optional<SymbolAlias> filter;

    private FunctionCallProvider(boolean isWindowFunction, QualifiedName name, Optional<WindowFrame> frame, boolean distinct, List<PlanTestSymbol> args, List<PlanMatchPattern.Ordering> orderBy, Optional<SymbolAlias> filter) {
        this.isWindowFunction = isWindowFunction;
        this.name = Objects.requireNonNull(name, "name is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
        this.distinct = distinct;
        this.args = Objects.requireNonNull(args, "args is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    FunctionCallProvider(QualifiedName name, Optional<WindowFrame> frame, boolean distinct, List<PlanTestSymbol> args) {
        this(true, name, frame, distinct, args, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), Optional.empty());
    }

    FunctionCallProvider(QualifiedName name, boolean distinct, List<PlanTestSymbol> args) {
        this(false, name, Optional.empty(), distinct, args, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), Optional.empty());
    }

    FunctionCallProvider(QualifiedName name, List<PlanTestSymbol> args, List<PlanMatchPattern.Ordering> orderBy) {
        this(false, name, Optional.empty(), false, args, orderBy, Optional.empty());
    }

    FunctionCallProvider(QualifiedName name, List<PlanTestSymbol> args) {
        this(false, name, Optional.empty(), false, args, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), Optional.empty());
    }

    FunctionCallProvider(QualifiedName name, List<PlanTestSymbol> args, SymbolAlias filter) {
        this(false, name, Optional.empty(), false, args, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), Optional.of(filter));
    }

    public String toString() {
        return String.format("%s%s (%s%s) %s %s", this.distinct ? "DISTINCT" : "", this.name, Joiner.on((String)", ").join(this.args), this.orderBy.isEmpty() ? "" : " ORDER BY " + Joiner.on((String)", ").join(this.orderBy), this.frame.isPresent() ? this.frame.get().toString() : "", this.filter.isPresent() ? this.filter.get().toString() : "");
    }

    @Override
    public FunctionCall getExpectedValue(SymbolAliases aliases) {
        List<Expression> symbolReferences = PlanMatchPattern.toSymbolReferences(this.args, aliases);
        if (this.isWindowFunction) {
            Verify.verify((!this.distinct ? 1 : 0) != 0, (String)"window does not support distinct", (Object[])new Object[0]);
            Verify.verify((boolean)this.orderBy.isEmpty(), (String)"window does not support order by", (Object[])new Object[0]);
            return new ExpectedWindowFunctionCall(symbolReferences);
        }
        Optional<Object> orderByClause = Optional.empty();
        if (!this.orderBy.isEmpty()) {
            orderByClause = Optional.of(new OrderBy(this.orderBy.stream().map(item -> new SortItem((Expression)Symbol.from((Expression)aliases.get(item.getField())).toSymbolReference(), item.getOrdering(), item.getNullOrdering())).collect(Collectors.toList())));
        }
        return new FunctionCall(Optional.empty(), this.name, Optional.empty(), this.filter.map(symbol -> symbol.toSymbol(aliases).toSymbolReference()), orderByClause, this.distinct, Optional.empty(), Optional.empty(), symbolReferences);
    }

    private class ExpectedWindowFunctionCall
    extends FunctionCall {
        private ExpectedWindowFunctionCall(List<Expression> args) {
            super(FunctionCallProvider.this.name, args);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof FunctionCall)) {
                return false;
            }
            FunctionCall other = (FunctionCall)object;
            return Objects.equals(FunctionCallProvider.this.name, other.getName()) && other.getWindow().isPresent() && other.getWindow().get() instanceof WindowSpecification && Objects.equals(FunctionCallProvider.this.frame, ((WindowSpecification)other.getWindow().get()).getFrame()) && Objects.equals(FunctionCallProvider.this.distinct, other.isDistinct()) && Objects.equals(this.getArguments(), other.getArguments());
        }

        public int hashCode() {
            throw new UnsupportedOperationException("Test object");
        }
    }
}

