/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.Util;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class LimitMatcher
implements Matcher {
    private final long limit;
    private final List<PlanMatchPattern.Ordering> tiesResolvers;
    private final boolean partial;
    private final List<SymbolAlias> preSortedInputs;

    public LimitMatcher(long limit, List<PlanMatchPattern.Ordering> tiesResolvers, boolean partial, List<SymbolAlias> preSortedInputs) {
        this.limit = limit;
        this.tiesResolvers = ImmutableList.copyOf((Collection)Objects.requireNonNull(tiesResolvers, "tiesResolvers is null"));
        this.partial = partial;
        this.preSortedInputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(preSortedInputs, "requiresPreSortedInputs is null"));
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof LimitNode)) {
            return false;
        }
        LimitNode limitNode = (LimitNode)node;
        return limitNode.getCount() == this.limit && limitNode.isWithTies() == !this.tiesResolvers.isEmpty() && limitNode.isPartial() == this.partial && limitNode.requiresPreSortedInputs() == !this.preSortedInputs.isEmpty();
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        LimitNode limitNode = (LimitNode)node;
        if (!limitNode.isWithTies()) {
            return MatchResult.match();
        }
        OrderingScheme tiesResolvingScheme = (OrderingScheme)limitNode.getTiesResolvingScheme().get();
        if (Util.orderingSchemeMatches(this.tiesResolvers, tiesResolvingScheme, symbolAliases)) {
            return MatchResult.match();
        }
        if (!limitNode.requiresPreSortedInputs()) {
            return MatchResult.match();
        }
        if (((ImmutableSet)this.preSortedInputs.stream().map(alias -> alias.toSymbol(symbolAliases)).collect(ImmutableSet.toImmutableSet())).equals((Object)ImmutableSet.copyOf((Collection)limitNode.getPreSortedInputs()))) {
            return MatchResult.match();
        }
        return MatchResult.NO_MATCH;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("limit", this.limit).add("tiesResolvers", this.tiesResolvers).add("partial", this.partial).add("requiresPreSortedInputs", this.preSortedInputs).toString();
    }
}

