/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjectIntoFilter;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.Map;
import org.testng.annotations.Test;

public class TestInlineProjectIntoFilter
extends BaseRuleTest {
    public TestInlineProjectIntoFilter() {
        super(new Plugin[0]);
    }

    @Test
    public void testInlineProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("b > 0")), (PlanNode)p.values(p.symbol("b"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.filter("b > 0", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("b")))));
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            return p.filter(PlanBuilder.expression("a AND b > c"), (PlanNode)p.project(Assignments.builder().put(a, PlanBuilder.expression("d IS NULL")).put(b, PlanBuilder.expression("b")).put(c, PlanBuilder.expression("c")).build(), (PlanNode)p.values(b, c, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"c", (Object)PlanMatchPattern.expression("c"), (Object)"a", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.filter("d IS NULL AND b > c", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"d", (Object)PlanMatchPattern.expression("d"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("b", "c", "d")))));
    }

    @Test
    public void testNoSimpleConjuncts() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a OR false"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("b > 0")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testMultipleReferencesToConjunct() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a AND a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("b > 0")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a AND (a OR false)"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("b > 0")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testInlineMultiple() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a AND b"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("c > 0"), (Symbol)p.symbol("b"), (Expression)PlanBuilder.expression("c > 5")), (PlanNode)p.values(p.symbol("c"))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter("c > 0 AND c > 5", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")))));
    }

    @Test
    public void testInlinePartially() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a AND a AND b"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("c > 0"), (Symbol)p.symbol("b"), (Expression)PlanBuilder.expression("c > 5")), (PlanNode)p.values(p.symbol("c"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.filter("a AND c > 5", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("c > 0"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")))));
    }

    @Test
    public void testTrivialProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("a")), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("a"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("b")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testCorrelationSymbol() {
        this.tester().assertThat((Rule<?>)new InlineProjectIntoFilter(this.tester().getMetadata())).on(p -> p.filter(PlanBuilder.expression("corr"), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)PlanBuilder.expression("b > 0")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }
}

