/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneAggregationColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneAggregationColumns
extends BaseRuleTest {
    public TestPruneAggregationColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneAggregationColumns()).on(p -> this.buildProjectedAggregation((PlanBuilder)p, symbol -> symbol.getName().equals("b"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("b"), PlanMatchPattern.functionCall("count", false, (List<PlanTestSymbol>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("key"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneAggregationColumns()).on(p -> this.buildProjectedAggregation((PlanBuilder)p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private ProjectNode buildProjectedAggregation(PlanBuilder planBuilder, Predicate<Symbol> projectionFilter) {
        Symbol a = planBuilder.symbol("a");
        Symbol b = planBuilder.symbol("b");
        Symbol key = planBuilder.symbol("key");
        return planBuilder.project(Assignments.identity((Iterable)((Iterable)ImmutableList.of((Object)a, (Object)b).stream().filter(projectionFilter).collect(ImmutableSet.toImmutableSet()))), (PlanNode)planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.values(key)).singleGroupingSet(key).addAggregation(a, PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).addAggregation(b, PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of())));
    }
}

