/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneJoinChildrenColumns
extends BaseRuleTest {
    public TestPruneJoinChildrenColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneJoinChildrenColumns()).on(p -> TestPruneJoinChildrenColumns.buildJoin(p, symbol -> symbol.getName().equals("leftValue"))).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("leftKey", "rightKey").filter("leftValue > 5").left(PlanMatchPattern.values("leftKey", "leftKeyHash", "leftValue")).right(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightKey", (Object)PlanMatchPattern.expression("rightKey"), (Object)"rightKeyHash", (Object)PlanMatchPattern.expression("rightKeyHash")), PlanMatchPattern.values("rightKey", "rightKeyHash", "rightValue")))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneJoinChildrenColumns()).on(p -> TestPruneJoinChildrenColumns.buildJoin(p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testCrossJoin() {
        this.tester().assertThat((Rule<?>)new PruneJoinChildrenColumns()).on(p -> {
            Symbol leftValue = p.symbol("leftValue");
            Symbol rightValue = p.symbol("rightValue");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftValue), (PlanNode)p.values(rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)leftValue), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("leftValue")).right(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values("rightValue")))));
    }

    private static PlanNode buildJoin(PlanBuilder p, Predicate<Symbol> joinOutputFilter) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol leftKeyHash = p.symbol("leftKeyHash");
        Symbol leftValue = p.symbol("leftValue");
        Symbol rightKey = p.symbol("rightKey");
        Symbol rightKeyHash = p.symbol("rightKeyHash");
        Symbol rightValue = p.symbol("rightValue");
        ImmutableList leftOutputs = ImmutableList.of((Object)leftValue);
        ImmutableList rightOutputs = ImmutableList.of((Object)rightValue);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftKey, leftKeyHash, leftValue), (PlanNode)p.values(rightKey, rightKeyHash, rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(leftKey, rightKey)), (List)leftOutputs.stream().filter(joinOutputFilter).collect(ImmutableList.toImmutableList()), (List)rightOutputs.stream().filter(joinOutputFilter).collect(ImmutableList.toImmutableList()), Optional.of(PlanBuilder.expression("leftValue > 5")), Optional.of(leftKeyHash), Optional.of(rightKeyHash));
    }
}

