/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneValuesColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneValuesColumns
extends BaseRuleTest {
    public TestPruneValuesColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("x")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("unused"), (Object)p.symbol("x")), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("1"), (Object)PlanBuilder.expression("2")), (Object)ImmutableList.of((Object)PlanBuilder.expression("3"), (Object)PlanBuilder.expression("4")))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"y", (Object)PlanMatchPattern.expression("x")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("2")), (Object)ImmutableList.of((Object)PlanBuilder.expression("4"))))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("x")), (PlanNode)p.values(p.symbol("x")))).doesNotFire();
    }

    @Test
    public void testPruneAllOutputs() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.values(5, p.symbol("x")))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values(5)));
    }

    @Test
    public void testPruneAllOutputsWhenValuesExpressionIsNotRow() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("x")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("CAST(ROW(1) AS row(bigint))"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values(1)));
    }

    @Test
    public void testDoNotPruneWhenValuesExpressionIsNotRow() {
        this.tester().assertThat((Rule<?>)new PruneValuesColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("x")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("x"), (Object)p.symbol("y")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("CAST(ROW(1, 'a') AS row(bigint, char(2)))"))))).doesNotFire();
    }
}

