/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveAggregationInSemiJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestRemoveAggregationInSemiJoin
extends BaseRuleTest {
    public TestRemoveAggregationInSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new RemoveAggregationInSemiJoin()).on(TestRemoveAggregationInSemiJoin::semiJoinWithDistinctAsFilteringSource).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.values("leftKey"), PlanMatchPattern.values("rightKey")));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveAggregationInSemiJoin()).on(TestRemoveAggregationInSemiJoin::semiJoinWithAggregationAsFilteringSource).doesNotFire();
    }

    private static PlanNode semiJoinWithDistinctAsFilteringSource(PlanBuilder p) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol rightKey = p.symbol("rightKey");
        return p.semiJoin(leftKey, rightKey, p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(leftKey), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(rightKey).source((PlanNode)p.values(rightKey))));
    }

    private static PlanNode semiJoinWithAggregationAsFilteringSource(PlanBuilder p) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol rightKey = p.symbol("rightKey");
        return p.semiJoin(leftKey, rightKey, p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(leftKey), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(rightKey, PlanBuilder.expression("count(rightValue)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("rightValue")))));
    }
}

