/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformCorrelatedScalarSubquery
extends BaseRuleTest {
    private static final ImmutableList<List<Expression>> ONE_ROW = ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")));
    private static final ImmutableList<List<Expression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new LongLiteral("2")));
    private Rule<?> rule = new TransformCorrelatedScalarSubquery((Metadata)MetadataManager.createTestMetadataManager());

    public TestTransformCorrelatedScalarSubquery() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutCorrelatedJoinlNode() {
        this.tester().assertThat(this.rule).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedNonScalar() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1"))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a")))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a2"), (Expression)PlanBuilder.expression("a * 2")), (PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS)))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("a * 2")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a"))))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjectionOnTopEnforceSingleNode() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a3"), (Expression)PlanBuilder.expression("a2 + 1")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a2"), (Expression)PlanBuilder.expression("a * 2")), (PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a3", (Object)PlanMatchPattern.expression("a2 + 1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("a * 2")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a")))))))));
    }

    @Test
    public void rewritesScalarSubquery() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ONE_ROW))))).matches(PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a"))));
    }

    private Expression ensureScalarSubquery() {
        return new SimpleCaseExpression((Expression)new SymbolReference("is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(new Cast((Expression)LogicalPlanner.failFunction((Metadata)this.tester().getMetadata(), (Session)this.tester().getSession(), (ErrorCodeSupplier)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS, (String)"Scalar sub-query has returned multiple rows"), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN))));
    }
}

