/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.UnwrapSingleColumnRowInApply;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.SymbolReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestUnwrapSingleColumnRowInApply
extends BaseRuleTest {
    public TestUnwrapSingleColumnRowInApply() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNoSingleColumnRow() {
        this.tester().assertThat((Rule<?>)new UnwrapSingleColumnRowInApply(TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.tester().getPlannerContext()))).on(p -> p.apply(Assignments.builder().put(p.symbol("output1", (Type)BooleanType.BOOLEAN), (Expression)new InPredicate((Expression)new SymbolReference("value"), (Expression)new SymbolReference("element"))).put(p.symbol("output2", (Type)BooleanType.BOOLEAN), (Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)new SymbolReference("value"), (Expression)new SymbolReference("element"))).build(), Collections.emptyList(), (PlanNode)p.values(p.symbol("value", (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.symbol("element", (Type)IntegerType.INTEGER)))).doesNotFire();
    }

    @Test
    public void testUnwrapInPredicate() {
        this.tester().assertThat((Rule<?>)new UnwrapSingleColumnRowInApply(TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.tester().getPlannerContext()))).on(p -> p.apply(Assignments.builder().put(p.symbol("unwrapped", (Type)BooleanType.BOOLEAN), (Expression)new InPredicate((Expression)new SymbolReference("rowValue"), (Expression)new SymbolReference("rowElement"))).put(p.symbol("notUnwrapped", (Type)BooleanType.BOOLEAN), (Expression)new InPredicate((Expression)new SymbolReference("nonRowValue"), (Expression)new SymbolReference("nonRowElement"))).build(), Collections.emptyList(), (PlanNode)p.values(p.symbol("rowValue", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowValue", (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.symbol("rowElement", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowElement", (Type)IntegerType.INTEGER)))).matches(PlanMatchPattern.project(PlanMatchPattern.apply(List.of(), (Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrapped", (Object)PlanMatchPattern.expression("unwrappedValue IN (unwrappedElement)")).put((Object)"notUnwrapped", (Object)PlanMatchPattern.expression("nonRowValue IN (nonRowElement)")).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedValue", (Object)PlanMatchPattern.expression("rowValue[1]")).put((Object)"nonRowValue", (Object)PlanMatchPattern.expression("nonRowValue")).buildOrThrow(), PlanMatchPattern.values("rowValue", "nonRowValue")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedElement", (Object)PlanMatchPattern.expression("rowElement[1]")).put((Object)"nonRowElement", (Object)PlanMatchPattern.expression("nonRowElement")).buildOrThrow(), PlanMatchPattern.values("rowElement", "nonRowElement")))));
    }

    @Test
    public void testUnwrapQuantifiedComparison() {
        this.tester().assertThat((Rule<?>)new UnwrapSingleColumnRowInApply(TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.tester().getPlannerContext()))).on(p -> p.apply(Assignments.builder().put(p.symbol("unwrapped", (Type)BooleanType.BOOLEAN), (Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)new SymbolReference("rowValue"), (Expression)new SymbolReference("rowElement"))).put(p.symbol("notUnwrapped", (Type)BooleanType.BOOLEAN), (Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)new SymbolReference("nonRowValue"), (Expression)new SymbolReference("nonRowElement"))).build(), Collections.emptyList(), (PlanNode)p.values(p.symbol("rowValue", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowValue", (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.symbol("rowElement", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowElement", (Type)IntegerType.INTEGER)))).matches(PlanMatchPattern.project(PlanMatchPattern.apply(List.of(), (Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrapped", (Object)PlanMatchPattern.expression((Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)new SymbolReference("unwrappedValue"), (Expression)new SymbolReference("unwrappedElement")))).put((Object)"notUnwrapped", (Object)PlanMatchPattern.expression((Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)new SymbolReference("nonRowValue"), (Expression)new SymbolReference("nonRowElement")))).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedValue", (Object)PlanMatchPattern.expression("rowValue[1]")).put((Object)"nonRowValue", (Object)PlanMatchPattern.expression("nonRowValue")).buildOrThrow(), PlanMatchPattern.values("rowValue", "nonRowValue")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedElement", (Object)PlanMatchPattern.expression("rowElement[1]")).put((Object)"nonRowElement", (Object)PlanMatchPattern.expression("nonRowElement")).buildOrThrow(), PlanMatchPattern.values("rowElement", "nonRowElement")))));
    }
}

